import { K as writable, m as setContext, S as head, T as bind_props, n as pop, U as slot, p as push, V as escape_html, W as store_get, X as unsubscribe_stores, Y as getContext, Z as attr, _ as attr_class, $ as ensure_array_like, a0 as stringify, a1 as spread_props } from './exports-Do6ngivA.js';
import { o as onDestroy } from './index-server-DUEkhmS8.js';
import { p as page } from './stores-CY0UdQZt.js';
import { $ as $format } from './runtime-tSokRynY.js';
import { b as ApiUtil, u as updateApiUrl, P as PANEL_URL, c as PLUGIN_DEV_MODE } from './api.util-D2jxxvoB.js';
import { n as notificationsCount, q as quickNotifications } from './Store-CyzmPbdB.js';
import './client-BeMlZc74.js';
import { N as NoContent } from './NoContent-CHLPGKcG.js';
import { i as init, l as locales, c as currentLanguage } from './language.util-CDe4A5iH.js';
import { h as html } from './html-FW6Ia4bL.js';
import './index2-DzcLzHBX.js';
import { E as ErrorAlert } from './ErrorAlert-tZ8MD4z-.js';
import { S as SuccessAlert } from './SuccessAlert-C9yb0ovT.js';
import fs from 'fs';
import { b as base } from './paths-DEXY_3zL.js';
import { f as formatDistanceToNow } from './formatDistanceToNow-CrEeDtkH.js';

function Header($$payload, $$props) {
  push();
  var $$store_subs;
  const session = getContext("session");
  $$payload.out += `<div class="bg-white border-bottom border-5 border-white"><div class="container"><img${attr("title", store_get($$store_subs ??= {}, "$session", session).siteInfo.websiteName)}${attr("alt", store_get($$store_subs ??= {}, "$_", $format)("components.header.alt"))} class="img-fluid d-block m-auto p-3" src="/api/websiteLogo"/></div></div>`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  pop();
}
const dataDefault$1 = { usernameOrEmail: "", password: "", recaptcha: "" };
const dialogID$1 = "loginModal";
const data$1 = writable(dataDefault$1);
const error$1 = writable();
function LoginModal($$payload, $$props) {
  push();
  var $$store_subs;
  let loading = false;
  getContext("session");
  $$payload.out += `<div class="modal fade"${attr("id", dialogID$1)} aria-hidden="true"><div class="modal-dialog modal-sm modal-dialog-centered" role="dialog"><div class="modal-content"><div class="modal-header"><h4 class="modal-title">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.modals.login.title"))}</h4> <button type="button" class="btn-close" data-bs-dismiss="modal"></button></div> <form><div class="modal-body"><div class="mb-3">`;
  ErrorAlert($$payload, { error: store_get($$store_subs ??= {}, "$error", error$1) });
  $$payload.out += `<!----></div> <div class="mb-3"><label for="usernameOrEmail">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.modals.login.inputs.username-email"))}</label> <input type="text" id="usernameOrEmail" class="form-control"${attr("value", store_get($$store_subs ??= {}, "$data", data$1).usernameOrEmail)}/></div> <div class="mb-3"><label for="password">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.modals.login.inputs.password"))}</label> <input type="password" id="password" class="form-control"${attr("value", store_get($$store_subs ??= {}, "$data", data$1).password)}/></div></div> <div class="modal-footer"><button type="submit"${attr_class("btn btn-primary w-100", void 0, { "disabled": loading })}${attr("disabled", loading, true)}>${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.modals.login.login-button"))}</button> <a href="/reset-password" class="btn btn-link w-100">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.modals.login.forgot-password-button"))}</a></div></form></div></div></div>`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  pop();
}
const dialogID = "registerModal";
const error = writable();
const successMessage = writable();
const dataDefault = {
  username: "",
  email: "",
  password: "",
  passwordRepeat: "",
  agreement: false,
  recaptcha: ""
};
const data = writable({ ...dataDefault });
function RegisterModal($$payload, $$props) {
  push();
  var $$store_subs;
  let loading = false;
  $$payload.out += `<div class="modal fade"${attr("id", dialogID)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-sm modal-dialog-centered"><div class="modal-content"><div class="modal-header"><h4 class="modal-title">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.modals.register.title"))}</h4> <button type="button" class="btn-close" data-bs-dismiss="modal"></button></div> <form><div class="modal-body"><div class="mb-3">`;
  SuccessAlert($$payload, {
    message: store_get($$store_subs ??= {}, "$successMessage", successMessage)
  });
  $$payload.out += `<!----> `;
  ErrorAlert($$payload, { error: store_get($$store_subs ??= {}, "$error", error) });
  $$payload.out += `<!----></div> <div class="mb-3"><label for="registerUserName">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.modals.register.inputs.username"))}</label> <input type="text" id="registerUserName" class="form-control"${attr("value", store_get($$store_subs ??= {}, "$data", data).username)}/></div> <div class="mb-3"><label for="registerEmail">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.modals.register.inputs.email"))}</label> <input type="email" id="registerEmail" class="form-control"${attr("value", store_get($$store_subs ??= {}, "$data", data).email)}/></div> <div class="mb-3"><label for="registerPassword">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.modals.register.inputs.password"))}</label> <input type="password" id="registerPassword" class="form-control"${attr("value", store_get($$store_subs ??= {}, "$data", data).password)}/></div> <div class="mb-3"><label for="registerPasswordRepeat">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.modals.register.inputs.password-repeat"))}</label> <input type="password" id="registerPasswordRepeat" class="form-control"${attr("value", store_get($$store_subs ??= {}, "$data", data).passwordRepeat)}/></div> <div class="mb-3"><div class="form-check"><input type="checkbox" class="form-check-input" id="registerAcceptTerms"${attr("checked", store_get($$store_subs ??= {}, "$data", data).agreement, true)}/> <label class="form-check-label" for="registerAcceptTerms">${html(store_get($$store_subs ??= {}, "$_", $format)("components.modals.register.inputs.agreement-text", {
    values: {
      link: `<a href="javascript:void(0);">${store_get($$store_subs ??= {}, "$_", $format)("components.modals.register.inputs.server-rules")}</a>`
    }
  }))}</label></div></div></div> <div class="modal-footer"><button type="submit"${attr_class("btn btn-primary w-100", void 0, { "disabled": loading })}${attr("disabled", loading, true)}>${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.modals.register.register-button"))}</button> <a href="javascript:void(0);" class="btn btn-link w-100">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.modals.register.already-registered-button"))}</a></div></form></div></div></div>`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  pop();
}
function Navbar($$payload, $$props) {
  push();
  var $$store_subs;
  let checkTime = 0;
  let interval;
  const session = getContext("session");
  function getTime(check, time, locale) {
    return formatDistanceToNow(time, { addSuffix: true, locale });
  }
  onDestroy(() => {
    clearInterval(interval);
  });
  $$payload.out += `<div class="py-3"><div class="container"><nav class="navbar navbar-expand-lg navbar-dark bg-primary bg-body-primary bg-gradient rounded-pill shadow svelte-1gikbjy"><div class="container"><ul class="navbar-nav flex-row me-auto"><button class="navbar-toggler d-lg-none" data-bs-target="#navbar" data-bs-toggle="collapse" type="button"><i aria-hidden="true" class="fa fa-bars"></i></button></ul> <ul class="navbar-nav flex-row ml-auto order-lg-last">`;
  if (store_get($$store_subs ??= {}, "$session", session).user && store_get($$store_subs ??= {}, "$session", session).user.panelAccess) {
    $$payload.out += "<!--[-->";
    $$payload.out += `<li class="nav-item"><a class="nav-link"${attr("href", PANEL_URL)} target="_blank" rel="noreferrer"><i class="fa-solid fa-table-columns fa-rotate-by me-1"></i> ${escape_html(store_get($$store_subs ??= {}, "$_", $format)("nav-links.panel"))}</a></li>`;
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]--> <div${attr_class("nav-item mx-lg-0 mx-3", void 0, {
    "d-none": !store_get($$store_subs ??= {}, "$session", session).user
  })} id="quickNotificationsDropdown"><div class="dropdown"><button class="nav-link" data-bs-toggle="dropdown" type="button"${attr("title", store_get($$store_subs ??= {}, "$_", $format)("navbar.notifications.title"))}><i class="fas fa-bolt"></i> `;
  if (store_get($$store_subs ??= {}, "$notificationsCount", notificationsCount) !== 0) {
    $$payload.out += "<!--[-->";
    $$payload.out += `<span class="position-absolute px-2 py-1 translate-middle badge rounded-pill bg-danger svelte-1gikbjy">${escape_html(store_get($$store_subs ??= {}, "$notificationsCount", notificationsCount))}</span>`;
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]--></button> <div class="dropdown-menu dropdown-menu-end position-absolute"><h6 class="dropdown-header">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("navbar.notifications.title"))}
                  ${escape_html(store_get($$store_subs ??= {}, "$notificationsCount", notificationsCount) === 0 ? "" : "(" + store_get($$store_subs ??= {}, "$notificationsCount", notificationsCount) + ")")}</h6> `;
  if (store_get($$store_subs ??= {}, "$quickNotifications", quickNotifications).length === 0) {
    $$payload.out += "<!--[-->";
    NoContent($$payload, {});
  } else {
    $$payload.out += "<!--[!-->";
    const each_array = ensure_array_like(store_get($$store_subs ??= {}, "$quickNotifications", quickNotifications));
    $$payload.out += `<!--[-->`;
    for (let index = 0, $$length = each_array.length; index < $$length; index++) {
      let notification = each_array[index];
      $$payload.out += `<button type="button"${attr_class("dropdown-item", void 0, { "notification-unread": notification.status === "NOT_READ" })}><p class="mb-0">${escape_html(notification.type)}</p> <small class="text-dark">${escape_html(getTime(checkTime, parseInt(notification.date), locales[store_get($$store_subs ??= {}, "$currentLanguage", currentLanguage).dateFnsCode]))}</small></button>`;
    }
    $$payload.out += `<!--]-->`;
  }
  $$payload.out += `<!--]--> <li class="dropdown-item bg-transparent"><a href="/notifications" class="btn btn-sm btn-primary w-100">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("navbar.notifications.show-all"))}</a></li></div></div></div> `;
  if (store_get($$store_subs ??= {}, "$session", session).user) {
    $$payload.out += "<!--[-->";
    $$payload.out += `<li class="nav-item mr-lg-0 mr-5"><a href="/profile" class="nav-link"${attr("title", store_get($$store_subs ??= {}, "$session", session).user.username)}><img${attr("alt", store_get($$store_subs ??= {}, "$session", session).user.username)} class="rounded d-block m-auto"${attr("src", `https://minotar.net/avatar/${stringify(store_get($$store_subs ??= {}, "$session", session).user.username)}`)} width="24" height="24"/></a></li>`;
  } else {
    $$payload.out += "<!--[!-->";
    $$payload.out += `<li class="nav-item me-xl-0 me-3"><button class="nav-link">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("navbar.login-button"))}</button></li> <li class="nav-item"><button type="button" class="btn btn-warning rounded-pill svelte-1gikbjy">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("navbar.register-button"))}</button></li>`;
  }
  $$payload.out += `<!--]--></ul> <div class="collapse navbar-collapse" id="navbar"><ul class="navbar-nav mr-auto mt-2 mt-lg-0"><li class="nav-item"><a class="nav-link"${attr("title", store_get($$store_subs ??= {}, "$_", $format)("nav-links.homepage"))} href="/">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("nav-links.homepage"))}</a></li> <li class="nav-item"><a href="/support" class="nav-link"${attr("title", store_get($$store_subs ??= {}, "$_", $format)("nav-links.support"))}>${escape_html(store_get($$store_subs ??= {}, "$_", $format)("nav-links.support"))}</a></li></ul></div></div></nav></div></div>`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  pop();
}
function Main($$payload, $$props) {
  push();
  var $$store_subs;
  const sidebar = getContext("sidebar");
  const sidebarProps = getContext("sidebarProps");
  $$payload.out += `<main class="container"><div class="row">`;
  if (!store_get($$store_subs ??= {}, "$sidebarProps", sidebarProps) || store_get($$store_subs ??= {}, "$sidebarProps", sidebarProps).side === "left") {
    $$payload.out += "<!--[-->";
    $$payload.out += `<!---->`;
    store_get($$store_subs ??= {}, "$sidebar", sidebar)?.($$payload, spread_props([
      store_get($$store_subs ??= {}, "$sidebarProps", sidebarProps)
    ]));
    $$payload.out += `<!---->`;
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]--> <div class="col"><!---->`;
  slot($$payload, $$props, "default", {}, null);
  $$payload.out += `<!----></div> `;
  if (!store_get($$store_subs ??= {}, "$sidebarProps", sidebarProps) || !store_get($$store_subs ??= {}, "$sidebarProps", sidebarProps).side) {
    $$payload.out += "<!--[-->";
    $$payload.out += `<!---->`;
    store_get($$store_subs ??= {}, "$sidebar", sidebar)?.($$payload, spread_props([
      store_get($$store_subs ??= {}, "$sidebarProps", sidebarProps)
    ]));
    $$payload.out += `<!---->`;
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]--></div></main>`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  pop();
}
function Footer($$payload, $$props) {
  push();
  var $$store_subs;
  getContext("session");
  $$payload.out += `<div class="container text-center my-3"><small>${html(store_get($$store_subs ??= {}, "$_", $format)("footer.been-created-with", {
    values: {
      pano: `<a href="https://panomc.com" target="_blank" rel="noreferrer">Pano</a>`
    }
  }))}</small></div>`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  pop();
}
function App($$payload, $$props) {
  $$payload.out += `<!---->`;
  slot($$payload, $$props, "default", {}, null);
  $$payload.out += `<!---->`;
}
const notifications = writable([]);
Array.prototype.insert = function(index, item) {
  this.splice(index, 0, item);
  return this;
};
Array.prototype.remove = function(index) {
  this.splice(index, 1);
  return this;
};
function NotificationContainer($$payload, $$props) {
  push();
  var $$store_subs;
  let checkTime = 0;
  let interval;
  getContext("session");
  function getTime(check, time, locale) {
    return formatDistanceToNow(time, { addSuffix: true, locale });
  }
  onDestroy(() => {
    clearInterval(interval);
  });
  const each_array = ensure_array_like(store_get($$store_subs ??= {}, "$notifications", notifications));
  $$payload.out += `<div class="toast-container position-fixed bottom-0 end-0 p-3 d-xl-block d-none"><!--[-->`;
  for (let index = 0, $$length = each_array.length; index < $$length; index++) {
    let notification = each_array[index];
    $$payload.out += `<div${attr("id", `notificationToast${stringify(notification.id)}`)} class="toast" role="alert" aria-live="assertive" aria-atomic="true"><div class="toast-header text-bg-primary"><strong class="me-auto">Pano</strong> <small>${escape_html(getTime(checkTime, parseInt(notification.date), locales[store_get($$store_subs ??= {}, "$currentLanguage", currentLanguage)["date-fns-code"]]))}</small> <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast"></button></div> <div class="toast-body">${escape_html(notification.type)}</div></div>`;
  }
  $$payload.out += `<!--]--></div>`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  pop();
}
let path, url, admZip;
{
  const pathStuff = await import('path');
  const urlStuff = await import('url');
  const admZipStuff = await import('./adm-zip-Bm0sib_i.js').then(function (n) { return n.a; });
  path = pathStuff;
  url = urlStuff;
  admZip = admZipStuff.default;
}
const plugins = {};
const pluginsFolder = "plugins";
const manifestFileName = "manifest.json";
const pluginUiZipFileName = "plugin-ui.zip";
function log(message) {
  console.log(`[Plugin Manager] ${message}`);
}
const pano = {
  isPanel: base === "/panel"
};
function createPluginsFolder() {
  if (!fs.existsSync(pluginsFolder)) {
    fs.mkdirSync(pluginsFolder, { recursive: true });
  }
}
function isDirectory(path2) {
  try {
    return fs.statSync(path2).isDirectory();
  } catch (error2) {
    return false;
  }
}
function isDirectoryEmpty(directoryPath) {
  try {
    const items = fs.readdirSync(directoryPath);
    return items.length === 0;
  } catch (error2) {
    return false;
  }
}
async function downloadAndExtractZip(file, outputDir) {
  const arrayBuffer = await file.arrayBuffer();
  const buffer = Buffer.from(arrayBuffer);
  const zip = new admZip(buffer, {});
  zip.extractAllTo(outputDir, true);
}
function readPluginsFromFolder() {
  const readPluginsFolder = fs.readdirSync(pluginsFolder);
  const plugins2 = {};
  readPluginsFolder.filter((pluginId) => isDirectory(path.join(pluginsFolder, pluginId))).forEach((pluginId) => {
    try {
      const manifestFile = fs.readFileSync(
        path.join(pluginsFolder, pluginId, manifestFileName),
        {
          encoding: "utf8",
          flag: "r"
        }
      );
      plugins2[pluginId] = JSON.parse(manifestFile);
    } catch (_) {
    }
  });
  return plugins2;
}
async function downloadPluginUiZip(pluginId) {
  return await ApiUtil.get({
    path: `/api/plugins/${pluginId}/resources/${pluginUiZipFileName}`,
    blob: true
  });
}
async function verifyPlugins(pluginsInFolder, pluginsInfo) {
  const pluginIdInFolderList = Object.keys(pluginsInFolder);
  pluginIdInFolderList.forEach((pluginId) => {
    const pluginFolder = path.join(pluginsFolder, pluginId);
    const serverIsDirectory = isDirectory(
      path.join(pluginFolder, "server")
    );
    const clientIsDirectory = isDirectory(
      path.join(pluginFolder, "client")
    );
    let remove;
    if (serverIsDirectory && !clientIsDirectory) {
      fs.rmSync(path.join(pluginFolder, "server"), {
        recursive: true,
        force: true
      });
      remove = true;
    }
    if (clientIsDirectory && !serverIsDirectory) {
      fs.rmSync(path.join(pluginFolder, "client"), {
        recursive: true,
        force: true
      });
      remove = true;
    }
    if (remove) {
      log(`Fixing broken '${pluginId}' folder...`);
      delete pluginsInFolder[pluginId];
      delete plugins[pluginId];
      delete pluginIdInFolderList[pluginIdInFolderList.indexOf(pluginId)];
      fs.rmSync(path.join(pluginFolder, manifestFileName), {
        recursive: true,
        force: true
      });
      if (isDirectoryEmpty(path.join(pluginFolder))) {
        fs.rmSync(path.join(pluginFolder), {
          recursive: true,
          force: true
        });
      }
    }
    if (!isDirectory(path.join(pluginFolder, "server")) && !isDirectory(path.join(pluginFolder, "client")) && fs.existsSync(path.join(pluginFolder, manifestFileName))) {
      fs.rmSync(path.join(pluginFolder, manifestFileName), {
        recursive: true,
        force: true
      });
    }
  });
  Object.keys(plugins).filter((pluginId) => !pluginIdInFolderList.includes(pluginId)).forEach((pluginId) => {
    log(`Removing plugin '${pluginId}'...`);
    delete plugins[pluginId];
  });
  pluginIdInFolderList.forEach((pluginId) => {
    if (!PLUGIN_DEV_MODE && !pluginsInfo[pluginId]) {
      log(`Removing '${pluginId}' folder...`);
      fs.rmSync(path.join(pluginsFolder, pluginId, "server"), {
        recursive: true,
        force: true
      });
      fs.rmSync(path.join(pluginsFolder, pluginId, "client"), {
        recursive: true,
        force: true
      });
      fs.rmSync(path.join(pluginsFolder, pluginId, manifestFileName), {
        recursive: true,
        force: true
      });
      if (isDirectoryEmpty(path.join(pluginsFolder, pluginId))) {
        fs.rmSync(path.join(pluginsFolder, pluginId), {
          recursive: true,
          force: true
        });
      }
      delete plugins[pluginId];
      return;
    }
    const manifestFile = fs.readFileSync(
      path.join(pluginsFolder, pluginId, manifestFileName),
      {
        encoding: "utf8",
        flag: "r"
      }
    );
    plugins[pluginId] = JSON.parse(manifestFile);
  });
  if (!PLUGIN_DEV_MODE) {
    const notInstalledPlugins = Object.keys(pluginsInfo).filter(
      (pluginId) => !plugins[pluginId]
    );
    for (const pluginId of notInstalledPlugins) {
      const pluginFolder = path.join(pluginsFolder, pluginId);
      const manifestFilePath = path.join(pluginFolder, manifestFileName);
      const pluginManifest = pluginsInfo[pluginId];
      log(`Installing plugin '${pluginId}'...`);
      if (!fs.existsSync(pluginFolder)) {
        fs.mkdirSync(pluginFolder, { recursive: true });
      }
      plugins[pluginId] = structuredClone(pluginManifest);
      log(`Downloading...`);
      const file = await downloadPluginUiZip(pluginId);
      await downloadAndExtractZip(file, pluginFolder);
      fs.writeFileSync(
        manifestFilePath,
        JSON.stringify(pluginManifest, null, 2)
      );
      log(`'${pluginId}' successfully installed.`);
    }
    for (const pluginId of Object.keys(plugins)) {
      const pluginFolder = path.join(pluginsFolder, pluginId);
      const pluginInfoManifest = pluginsInfo[pluginId];
      let pluginManifest = plugins[pluginId];
      if (pluginManifest.version !== pluginInfoManifest.version || pluginManifest.uiHash !== pluginInfoManifest.uiHash) {
        const manifestFilePath = path.join(pluginFolder, manifestFileName);
        log(`Updating plugin '${pluginId}'.`);
        plugins[pluginId] = structuredClone(pluginInfoManifest);
        pluginManifest = plugins[pluginId];
        fs.writeFileSync(
          manifestFilePath,
          JSON.stringify(pluginManifest, null, 2)
        );
        fs.rmSync(path.join(pluginsFolder, pluginId, "server"), {
          recursive: true,
          force: true
        });
        fs.rmSync(path.join(pluginsFolder, pluginId, "client"), {
          recursive: true,
          force: true
        });
        log(`Downloading...`);
        const file = await downloadPluginUiZip(pluginId);
        await downloadAndExtractZip(file, pluginFolder);
        log(`'${pluginId}' successfully updated.`);
      }
    }
  }
}
async function preparePlugins(siteInfo) {
  createPluginsFolder();
  const pluginsInFolder = readPluginsFromFolder();
  await verifyPlugins(pluginsInFolder, siteInfo.plugins);
}
async function initializePlugins(siteInfo) {
  {
    await preparePlugins(siteInfo);
  }
  siteInfo.plugins;
  await loadPlugins();
  await enablePlugins();
}
async function loadPlugins() {
  for (const pluginId of Object.keys(plugins)) {
    const plugin = plugins[pluginId];
    {
      const pluginFolder = path.join(pluginsFolder, pluginId);
      const mainPath = path.join(pluginFolder, "server", "server.mjs") + `?${Date.now()}`;
      const __filename = url.fileURLToPath(import.meta.url);
      const currentDir = path.dirname(__filename);
      const targetFile = path.resolve(currentDir, process.cwd());
      const relativePath = path.relative(currentDir, targetFile);
      const levels = relativePath.split(path.sep).length;
      const upDirs = `..${path.sep}`.repeat(levels);
      let module;
      try {
        module = await import(
          /* @vite-ignore */
          upDirs + mainPath
        );
      } catch {
        module = await import(
          /* @vite-ignore */
          "file://" + path.join(path.resolve(upDirs + mainPath, process.cwd(), mainPath))
        );
      }
      plugin.module = module;
    }
  }
  for (const pluginId of Object.keys(plugins)) {
    const plugin = plugins[pluginId];
    if (plugin.module.onLoad !== void 0) {
      await plugin.module.onLoad(pano);
    }
  }
}
async function enablePlugins() {
  for (const pluginId of Object.keys(plugins)) {
    const plugin = plugins[pluginId];
    if (plugin.module.onEnable !== void 0) {
      await plugin.module.onEnable(pano);
    }
  }
}
async function loadServer(event) {
  const { locals: { user, csrfToken, apiUrlEnv, panoWebsiteUrlEnv } } = event;
  let siteInfo = await ApiUtil.get({ path: "/api/siteInfo", request: event, csrfToken });
  return { user, csrfToken, siteInfo, apiUrlEnv, panoWebsiteUrlEnv };
}
async function load(event) {
  const {
    data: { user, csrfToken, siteInfo, apiUrlEnv, panoWebsiteUrlEnv },
    parent
  } = event;
  await parent();
  if (apiUrlEnv) {
    updateApiUrl(apiUrlEnv);
  }
  await initializePlugins(siteInfo);
  const output = { session: { user, csrfToken, siteInfo } };
  await init(siteInfo.locale, event);
  return output;
}
function MainLayout($$payload, $$props) {
  push();
  var $$store_subs;
  let data2 = $$props["data"];
  const session = writable(data2.session);
  const sidebar = writable(null);
  const sidebarProps = writable({});
  const pageUnsubscribe = page.subscribe((page2) => {
    session.update(() => page2.data.session);
    sidebar.update(() => page2.data.sidebar);
    sidebarProps.update(() => page2.data.sidebarProps || {});
  });
  setContext("session", session);
  setContext("sidebar", sidebar);
  setContext("sidebarProps", sidebarProps);
  onDestroy(pageUnsubscribe);
  head($$payload, ($$payload2) => {
    $$payload2.title = `<title>${escape_html(store_get($$store_subs ??= {}, "$session", session).siteInfo.websiteName)}</title>`;
  });
  App($$payload, {
    children: ($$payload2) => {
      Header($$payload2);
      $$payload2.out += `<!----> `;
      Navbar($$payload2);
      $$payload2.out += `<!----> <div class="container"><div class="mb-3"><div class="alert alert-warning alert-dismissible fade show" role="alert"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button> Alert 1</div></div></div> `;
      Main($$payload2, {
        children: ($$payload3) => {
          $$payload3.out += `<!---->`;
          slot($$payload3, $$props, "default", {}, null);
          $$payload3.out += `<!---->`;
        },
        $$slots: { default: true }
      });
      $$payload2.out += `<!----> `;
      Footer($$payload2);
      $$payload2.out += `<!----> `;
      LoginModal($$payload2);
      $$payload2.out += `<!----> `;
      RegisterModal($$payload2);
      $$payload2.out += `<!----> `;
      NotificationContainer($$payload2);
      $$payload2.out += `<!---->`;
    },
    $$slots: { default: true }
  });
  if ($$store_subs) unsubscribe_stores($$store_subs);
  bind_props($$props, { data: data2 });
  pop();
}

var _layout = /*#__PURE__*/Object.freeze({
  __proto__: null,
  load: load
});

var _layout_server = /*#__PURE__*/Object.freeze({
  __proto__: null,
  load: loadServer
});

const index = 0;
let component_cache;
const component = async () => component_cache ??= (await import('./_layout.svelte-W2AcM-Ol.js')).default;
const universal_id = "src/routes/+layout.js";
const server_id = "src/routes/+layout.server.js";
const imports = ["_app/immutable/nodes/0.DtYZkitY.js","_app/immutable/chunks/NZTpNUN0.js","_app/immutable/chunks/A5Q-2kZ4.js","_app/immutable/chunks/D5TKtvHY.js","_app/immutable/chunks/fllelwxA.js","_app/immutable/chunks/Cj5Xjk0G.js","_app/immutable/chunks/B47GiyGV.js","_app/immutable/chunks/CP7Uhx1M.js","_app/immutable/chunks/BXqfVL7H.js","_app/immutable/chunks/B0OlVNmS.js","_app/immutable/chunks/tAItdJCZ.js","_app/immutable/chunks/DVC5Gnwt.js","_app/immutable/chunks/BWpyQU__.js","_app/immutable/chunks/DpYKOcCi.js","_app/immutable/chunks/Cd5_9v32.js","_app/immutable/chunks/D5Za9yOS.js","_app/immutable/chunks/DKsB_7LU.js","_app/immutable/chunks/V8QYqjjF.js","_app/immutable/chunks/ZmdumO3u.js","_app/immutable/chunks/D4Caz1gY.js","_app/immutable/chunks/IHkhavGh.js","_app/immutable/chunks/qMI2V-ei.js","_app/immutable/chunks/CusXQRgR.js"];
const stylesheets = ["_app/immutable/assets/0.-vzlGKVS.css"];
const fonts = [];

var _0 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  component: component,
  fonts: fonts,
  imports: imports,
  index: index,
  server: _layout_server,
  server_id: server_id,
  stylesheets: stylesheets,
  universal: _layout,
  universal_id: universal_id
});

export { MainLayout as M, _0 as _ };
//# sourceMappingURL=0-xDZnCOWj.js.map
