import { V as escape_html, W as store_get, X as unsubscribe_stores, T as bind_props, n as pop, p as push } from './exports-Do6ngivA.js';
import { $ as $format } from './runtime-tSokRynY.js';
import { b as getPostPreview, P as Post } from './posts-BTMoHU4r.js';

async function load(event) {
  const { parent } = event;
  const parentData = await parent();
  const { session } = parentData;
  const { user } = session;
  if (!user && !user.panelAccess) {
    return { status: 302, redirect: "/" };
  }
  let data = {
    post: {
      id: -1,
      title: "",
      category: "-",
      writer: { username: "" },
      text: "",
      date: 0,
      status: 1,
      image: "",
      views: 0
    },
    previousPost: "-",
    nextPost: "-"
  };
  await getPostPreview({ id: event.params.id, request: event }).then((body) => {
    if (body.error) {
      data = {};
      return;
    }
    data.post = body;
  });
  return data;
}
function PreviewPost($$payload, $$props) {
  push();
  var $$store_subs;
  let post = $$props["post"];
  $$payload.out += `<h5 class="card-title mb-3">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("pages.preview-post.title", { values: { postTitle: post.title } }))}</h5> `;
  Post($$payload, { post, detail: true });
  $$payload.out += `<!---->`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  bind_props($$props, { post });
  pop();
}

var _page = /*#__PURE__*/Object.freeze({
  __proto__: null,
  load: load
});

const index = 11;
let component_cache;
const component = async () => component_cache ??= (await import('./_page.svelte-D5_h6C4K.js')).default;
const universal_id = "src/routes/preview/post/[id]/+page.js";
const imports = ["_app/immutable/nodes/11.Cns8JHgC.js","_app/immutable/chunks/NZTpNUN0.js","_app/immutable/chunks/A5Q-2kZ4.js","_app/immutable/chunks/D5TKtvHY.js","_app/immutable/chunks/fllelwxA.js","_app/immutable/chunks/B47GiyGV.js","_app/immutable/chunks/CP7Uhx1M.js","_app/immutable/chunks/UbinW0dQ.js","_app/immutable/chunks/BXqfVL7H.js","_app/immutable/chunks/Cd5_9v32.js","_app/immutable/chunks/qMI2V-ei.js","_app/immutable/chunks/0nBbjdj7.js","_app/immutable/chunks/XSHPCi-H.js","_app/immutable/chunks/DpYKOcCi.js","_app/immutable/chunks/tAItdJCZ.js","_app/immutable/chunks/BqE1et2F.js","_app/immutable/chunks/Cj5Xjk0G.js","_app/immutable/chunks/B0OlVNmS.js","_app/immutable/chunks/BBdd__bl.js"];
const stylesheets = [];
const fonts = [];

var _11 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  component: component,
  fonts: fonts,
  imports: imports,
  index: index,
  stylesheets: stylesheets,
  universal: _page,
  universal_id: universal_id
});

export { PreviewPost as P, _11 as _ };
//# sourceMappingURL=11-C9GbRTTn.js.map
