import { $ as ensure_array_like, _ as attr_class, V as escape_html, W as store_get, Z as attr, a0 as stringify, X as unsubscribe_stores, T as bind_props, n as pop, p as push } from './exports-Do6ngivA.js';
import { $ as $format } from './runtime-tSokRynY.js';
import { D as Date_1 } from './Date-B9qW_84W.js';
import './client-BeMlZc74.js';
import { g as getTicketDetail, T as TicketStatuses, a as TicketStatus } from './TicketStatus-Cqgq9C2b.js';
import { e as error } from './index2-DzcLzHBX.js';
import { l as load$1, T as TicketCreateAndDetailSidebar } from './TicketCreateAndDetailSidebar-Bqa29WeZ.js';
import { h as html } from './html-FW6Ia4bL.js';

async function load(event) {
  const { parent } = event;
  await parent();
  let data = {
    ticket: {
      id: -1,
      username: "",
      title: "",
      category: "-",
      messages: [],
      status: 1,
      date: 0,
      messageCount: 0
    }
  };
  await getTicketDetail({ id: event.params.id, request: event }).then((body) => {
    if (body.error) {
      if (body.error === "NOT_EXISTS") {
        throw error(404, body.error);
      }
      throw error(500, body.error);
    }
    data = body;
  });
  await load$1(event, data.ticket);
  return { ...data, sidebar: TicketCreateAndDetailSidebar };
}
function TicketDetail($$payload, $$props) {
  push();
  var $$store_subs;
  let isSendButtonDisabled;
  let data = $$props["data"];
  let message = "";
  let loadMoreLoading = false;
  let sentMessageCount = 0;
  isSendButtonDisabled = message === "";
  const each_array = ensure_array_like(data.ticket.messages);
  $$payload.out += `<article class="container"><div class="card"><div${attr_class("card-header bg-opacity-25 py-3 rounded-top", void 0, {
    "bg-secondary": data.ticket.status === TicketStatuses.NEW,
    "bg-warning": data.ticket.status === TicketStatuses.REPLIED,
    "bg-danger": data.ticket.status === TicketStatuses.CLOSED
  })}><div class="row"><div class="col"><h5 class="card-title">${escape_html(data.ticket.title)}</h5> <small class="mb-0">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("pages.ticket-detail.detail.ticket", { values: { ticketId: data.ticket.id } }))}, `;
  Date_1($$payload, { time: data.ticket.date, relativeFormat: true });
  $$payload.out += `<!----> , ${html(store_get($$store_subs ??= {}, "$_", $format)("pages.ticket-detail.detail.opened-in-category", {
    values: {
      category: `<a
              href="/tickets?category=${data.ticket.category.url}"
              title="${store_get($$store_subs ??= {}, "$_", $format)("pages.ticket-detail.filter")}"
              >${data.ticket.category === "-" ? store_get($$store_subs ??= {}, "$_", $format)("pages.ticket-detail.no-category") : data.ticket.category.title}
            </a>`
    }
  }))}</small></div> <div class="col-auto">`;
  TicketStatus($$payload, { status: data.ticket.status });
  $$payload.out += `<!----></div></div></div> <div class="card-body" id="messageSection">`;
  if (data.ticket.messages.length < data.ticket.messageCount && data.ticket.messageCount > 5) {
    $$payload.out += "<!--[-->";
    $$payload.out += `<button${attr_class("btn btn-link bg-light d-block m-auto", void 0, { "disabled": loadMoreLoading })}><i class="fas fa-arrow-up mr-1"></i> ${escape_html(store_get($$store_subs ??= {}, "$_", $format)("pages.ticket-detail.previous-messages", {
      values: {
        count: data.ticket.messageCount - (data.ticket.messages.length - sentMessageCount)
      }
    }))}</button>`;
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]--> <!--[-->`;
  for (let index = 0, $$length = each_array.length; index < $$length; index++) {
    let message2 = each_array[index];
    if (message2.panel) {
      $$payload.out += "<!--[-->";
      $$payload.out += `<div class="row py-2 flex-nowrap justify-content-start"><div class="col-auto"><a${attr("href", `/player/${stringify(message2.username)}`)}><img${attr("src", `https://minotar.net/avatar/${stringify(message2.username)}/48`)}${attr("alt", message2.username)} class="rounded d-block mr-auto animate__animated animate__zoomIn" width="48" height="48" onload="this.__e=event" onerror="this.__e=event"/></a></div> <div class="col-auto"><div class="card text-bg-light"><div class="card-header small">`;
      Date_1($$payload, { time: message2.date });
      $$payload.out += `<!----></div> <div class="card-body answer">${html(message2.message)}</div></div></div></div>`;
    } else {
      $$payload.out += "<!--[!-->";
      $$payload.out += `<div class="row py-2 flex-nowrap justify-content-end"><div class="col-auto"><a${attr("href", `/player/${stringify(message2.username)}`)}><img${attr("src", `https://minotar.net/avatar/${stringify(message2.username)}/48`)}${attr("alt", message2.username)} class="rounded animate__animated animate__zoomIn" width="48" height="48" onload="this.__e=event" onerror="this.__e=event"/></a></div> <div class="col-auto"><div class="card text-bg-secondary"><div class="card-header small">`;
      Date_1($$payload, { time: message2.date });
      $$payload.out += `<!----></div> <div class="card-body">${escape_html(message2.message)}</div></div></div></div>`;
    }
    $$payload.out += `<!--]-->`;
  }
  $$payload.out += `<!--]--> <div${attr_class("row align-items-end mt-3", void 0, { "d-none": data.ticket.status === TicketStatuses.CLOSED })}><div class="col"><textarea${attr("placeholder", store_get($$store_subs ??= {}, "$_", $format)("pages.ticket-detail.inputs.message.placeholder"))} class="form-control">`;
  const $$body = escape_html(message);
  if ($$body) {
    $$payload.out += `${$$body}`;
  }
  $$payload.out += `</textarea></div> <div class="col-auto"><button${attr_class("btn btn-secondary", void 0, { "disabled": isSendButtonDisabled })}${attr(":disabled", isSendButtonDisabled)}><i class="fas fa-paper-plane"></i> <span class="d-xl-inline d-none ms-2">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("pages.ticket-detail.send-button"))}</span></button></div></div></div></div></article>`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  bind_props($$props, { data });
  pop();
}

var _page = /*#__PURE__*/Object.freeze({
  __proto__: null,
  load: load
});

const index = 17;
let component_cache;
const component = async () => component_cache ??= (await import('./_page.svelte-BF267wSC.js')).default;
const universal_id = "src/routes/ticket/[id]/+page.js";
const imports = ["_app/immutable/nodes/17.BYglhYAp.js","_app/immutable/chunks/NZTpNUN0.js","_app/immutable/chunks/A5Q-2kZ4.js","_app/immutable/chunks/D5TKtvHY.js","_app/immutable/chunks/fllelwxA.js","_app/immutable/chunks/Cd5_9v32.js","_app/immutable/chunks/D5Za9yOS.js","_app/immutable/chunks/qMI2V-ei.js","_app/immutable/chunks/0nBbjdj7.js","_app/immutable/chunks/XSHPCi-H.js","_app/immutable/chunks/DpYKOcCi.js","_app/immutable/chunks/DKsB_7LU.js","_app/immutable/chunks/ZmdumO3u.js","_app/immutable/chunks/x7WCQR5p.js","_app/immutable/chunks/B47GiyGV.js","_app/immutable/chunks/CP7Uhx1M.js","_app/immutable/chunks/BPdWA3EL.js","_app/immutable/chunks/BXqfVL7H.js","_app/immutable/chunks/tAItdJCZ.js","_app/immutable/chunks/C52Z-krK.js","_app/immutable/chunks/Cj5Xjk0G.js","_app/immutable/chunks/DR4AFTSh.js","_app/immutable/chunks/0QwLbeAv.js","_app/immutable/chunks/IHkhavGh.js","_app/immutable/chunks/BqE1et2F.js","_app/immutable/chunks/B0OlVNmS.js","_app/immutable/chunks/BBdd__bl.js"];
const stylesheets = ["_app/immutable/assets/17.mj9Ow22B.css"];
const fonts = [];

var _17 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  component: component,
  fonts: fonts,
  imports: imports,
  index: index,
  stylesheets: stylesheets,
  universal: _page,
  universal_id: universal_id
});

export { TicketDetail as T, _17 as _ };
//# sourceMappingURL=17-BDaoDOv8.js.map
