import { C as COOKIE_PREFIX, J as JWT_COOKIE_NAME, a as CSRF_TOKEN_COOKIE_NAME, A as API_URL, b as ApiUtil, u as updateApiUrl } from './api.util-D2jxxvoB.js';
import './exports-Do6ngivA.js';
import './client-BeMlZc74.js';
import './Store-CyzmPbdB.js';
import './index2-DzcLzHBX.js';

const getCredentialsServerSide = async (token) => {
  return ApiUtil.get({ path: "/api/auth/credentials", token }).then((response) => {
    if (response.result !== "ok") {
      return null;
    }
    return Object.keys(response).filter((key) => !["result"].includes(key)).reduce((object, key) => {
      object[key] = response[key];
      return object;
    }, {});
  });
};
async function handle({
  event,
  event: {
    cookies,
    url: { pathname }
  },
  resolve
}) {
  const locals = {};
  const apiUrlEnv = process.env.API_URL;
  const panoWebsiteUrlEnv = process.env.PANO_WEBSITE_URL;
  if (apiUrlEnv) {
    updateApiUrl(apiUrlEnv);
    locals.apiUrlEnv = apiUrlEnv;
  }
  if (panoWebsiteUrlEnv) {
    locals.panoWebsiteUrlEnv = panoWebsiteUrlEnv;
  }
  const jwt = cookies.get(COOKIE_PREFIX + JWT_COOKIE_NAME);
  const csrfToken = cookies.get(COOKIE_PREFIX + CSRF_TOKEN_COOKIE_NAME);
  locals.user = jwt && csrfToken && !pathname.startsWith("/api/") && !pathname.startsWith("/auth/") && await getCredentialsServerSide(jwt);
  locals.csrfToken = csrfToken;
  event.locals = locals;
  return resolve(event);
}
async function handleFetch({ event, request, fetch }) {
  if (request.url.startsWith(API_URL)) {
    request.headers.set("cookie", event.request.headers.get("cookie"));
    request.headers.set("Origin", API_URL);
  }
  return fetch(request);
}

export { handle, handleFetch };
//# sourceMappingURL=hooks.server-BhQK8jNr.js.map
