import { $ as ensure_array_like, V as escape_html, W as store_get, Z as attr, a4 as maybe_selected, _ as attr_class, X as unsubscribe_stores, T as bind_props, n as pop, p as push } from './exports-Do6ngivA.js';
import './client-BeMlZc74.js';
import { b as getTicketCategories } from './TicketStatus-Cqgq9C2b.js';
import { E as ErrorAlert } from './ErrorAlert-tZ8MD4z-.js';
import { e as error } from './index2-DzcLzHBX.js';
import { $ as $format } from './runtime-tSokRynY.js';
import { l as load$1, T as TicketCreateAndDetailSidebar } from './TicketCreateAndDetailSidebar-Bqa29WeZ.js';

async function load(event) {
  const { parent } = event;
  await parent();
  let data = { categories: [], categoryPage: 0 };
  await load$1(event);
  await getTicketCategories({ page: data.categoryPage, request: event }).then((body) => {
    if (body.error) {
      if (body.error === "NOT_EXISTS") {
        throw error(404, body.error);
      }
      throw error(500, body.error);
    }
    data = body;
  });
  return { ...data, sidebar: TicketCreateAndDetailSidebar };
}
function TicketCreate($$payload, $$props) {
  push();
  var $$store_subs;
  let isButtonDisabled;
  let data = $$props["data"];
  let error2;
  let title = "";
  let message = "";
  let categoryId = -1;
  isButtonDisabled = title === "";
  const each_array = ensure_array_like(data.categories);
  $$payload.out += `<div class="card"><div class="card-body"><div class="row justify-content-between mb-3"><div class="col-auto"><h4 class="card-title">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("pages.create-ticket.title"))}</h4></div></div> `;
  ErrorAlert($$payload, { error: error2 });
  $$payload.out += `<!----> <div class="mb-3"><input type="text" class="form-control form-control-lg mb-3"${attr("placeholder", store_get($$store_subs ??= {}, "$_", $format)("pages.create-ticket.inputs.title"))}${attr("value", title)}/> <select class="form-select" id="datalistOptions">`;
  $$payload.select_value = categoryId;
  $$payload.out += `<option${attr("value", -1)}${maybe_selected($$payload, -1)}>${escape_html(store_get($$store_subs ??= {}, "$_", $format)("pages.create-ticket.inputs.no-category"))}</option><!--[-->`;
  for (let index = 0, $$length = each_array.length; index < $$length; index++) {
    let category = each_array[index];
    $$payload.out += `<option${attr("value", category.id)}${maybe_selected($$payload, category.id)}>${escape_html(category.title)}</option>`;
  }
  $$payload.out += `<!--]-->`;
  $$payload.select_value = void 0;
  $$payload.out += `</select></div> <div class="mb-3"><textarea class="form-control" rows="6">`;
  const $$body = escape_html(message);
  if ($$body) {
    $$payload.out += `${$$body}`;
  }
  $$payload.out += `</textarea></div> <button${attr_class("btn btn-primary w-100", void 0, { "disabled": isButtonDisabled })}${attr("disabled", isButtonDisabled, true)}>${escape_html(store_get($$store_subs ??= {}, "$_", $format)("pages.create-ticket.create-button"))}</button></div></div>`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  bind_props($$props, { data });
  pop();
}

var _page = /*#__PURE__*/Object.freeze({
  __proto__: null,
  load: load
});

const index = 18;
let component_cache;
const component = async () => component_cache ??= (await import('./_page.svelte-K9E9F4fB.js')).default;
const universal_id = "src/routes/ticket/create/+page.js";
const imports = ["_app/immutable/nodes/18.CCmhHEJz.js","_app/immutable/chunks/NZTpNUN0.js","_app/immutable/chunks/A5Q-2kZ4.js","_app/immutable/chunks/D5TKtvHY.js","_app/immutable/chunks/fllelwxA.js","_app/immutable/chunks/D5Za9yOS.js","_app/immutable/chunks/DpYKOcCi.js","_app/immutable/chunks/DKsB_7LU.js","_app/immutable/chunks/ZmdumO3u.js","_app/immutable/chunks/B47GiyGV.js","_app/immutable/chunks/CP7Uhx1M.js","_app/immutable/chunks/BPdWA3EL.js","_app/immutable/chunks/Cd5_9v32.js","_app/immutable/chunks/BXqfVL7H.js","_app/immutable/chunks/tAItdJCZ.js","_app/immutable/chunks/C52Z-krK.js","_app/immutable/chunks/Cj5Xjk0G.js","_app/immutable/chunks/DR4AFTSh.js","_app/immutable/chunks/0nBbjdj7.js","_app/immutable/chunks/XSHPCi-H.js","_app/immutable/chunks/0QwLbeAv.js","_app/immutable/chunks/IHkhavGh.js"];
const stylesheets = [];
const fonts = [];

var _18 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  component: component,
  fonts: fonts,
  imports: imports,
  index: index,
  stylesheets: stylesheets,
  universal: _page,
  universal_id: universal_id
});

export { TicketCreate as T, _18 as _ };
//# sourceMappingURL=18-CQIqhF0W.js.map
