import { W as store_get, V as escape_html, _ as attr_class, X as unsubscribe_stores, T as bind_props, n as pop, p as push, $ as ensure_array_like, Z as attr, a0 as stringify } from './exports-Do6ngivA.js';
import { $ as $format } from './runtime-tSokRynY.js';
import './client-BeMlZc74.js';
import { P as Pagination } from './Pagination-DZqFhXsC.js';
import { c as getTickets, T as TicketStatuses, a as TicketStatus } from './TicketStatus-Cqgq9C2b.js';
import { D as Date_1 } from './Date-B9qW_84W.js';
import { N as NoContent } from './NoContent-CHLPGKcG.js';
import { e as error } from './index2-DzcLzHBX.js';
import { l as load$1, P as ProfileSidebar } from './ProfileSidebar-CEN-bkFR.js';
import { h as html } from './html-FW6Ia4bL.js';

function TicketRow($$payload, $$props) {
  push();
  var $$store_subs;
  let ticket = $$props["ticket"];
  $$payload.out += `<tr${attr_class("", void 0, { "table-primary": ticket.selected })}><th scope="row">`;
  if (ticket.status !== TicketStatuses.CLOSED) {
    $$payload.out += "<!--[-->";
    $$payload.out += `<a class="btn btn-link link-danger" role="button" href="javascript:void(0);"><i class="fas fa-times"></i></a>`;
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]--></th><td class="align-middle text-nowrap"><a${attr("href", `/ticket/${stringify(ticket.id)}`)}${attr("title", store_get($$store_subs ??= {}, "$_", $format)("components.ticket-row.show-ticket"))}>#${escape_html(ticket.id)} ${escape_html(ticket.title)}</a></td><td class="align-middle text-nowrap">`;
  TicketStatus($$payload, { status: ticket.status });
  $$payload.out += `<!----></td><td class="align-middle text-nowrap"><a class="badge rounded-pill bg-light text-black"${attr("href", `/tickets?category=${stringify(ticket.category.url)}`)}>${escape_html(ticket.category.title === "-" ? store_get($$store_subs ??= {}, "$_", $format)("components.ticket-row.no-category") : ticket.category.title)}</a></td><td class="align-middle text-nowrap"><span>`;
  Date_1($$payload, { time: ticket.lastUpdate });
  $$payload.out += `<!----></span></td></tr>`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  bind_props($$props, { ticket });
  pop();
}
function Tickets($$payload, $$props) {
  push();
  var $$store_subs;
  let tickets = $$props["tickets"];
  if (tickets.length > 0) {
    $$payload.out += "<!--[-->";
    const each_array = ensure_array_like(tickets);
    $$payload.out += `<div class="table-responsive"><table class="table table-hover"><thead><tr><th class="align-middle" scope="col"></th><th class="align-middle" scope="col">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.tickets.table.title"))}</th><th class="align-middle" scope="col">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.tickets.table.status"))}</th><th class="align-middle" scope="col">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.tickets.table.category"))}</th><th class="align-middle" scope="col">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.tickets.table.last-reply"))}</th></tr></thead><tbody><!--[-->`;
    for (let index = 0, $$length = each_array.length; index < $$length; index++) {
      let ticket = each_array[index];
      TicketRow($$payload, { ticket });
    }
    $$payload.out += `<!--]--></tbody></table></div>`;
  } else {
    $$payload.out += "<!--[!-->";
    NoContent($$payload, {});
  }
  $$payload.out += `<!--]-->`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  bind_props($$props, { tickets });
  pop();
}
const PageTypes = Object.freeze({ ALL: "ALL", CLOSED: "CLOSED" });
const DefaultPageType = PageTypes.ALL;
async function load(event) {
  const { parent, url: { searchParams } } = event;
  await parent();
  const page = parseInt(searchParams.get("page")) || 1;
  const pageType = searchParams.get("pageType") || DefaultPageType;
  const categoryUrl = searchParams.get("category");
  const data = await getTickets({ page, pageType, categoryUrl, request: event });
  if (data.error) {
    if (data.error === "PAGE_NOT_FOUND" || data.error === "NOT_EXISTS") {
      throw error(404, data.error);
    }
    throw error(500, data.error);
  }
  data.pageType = pageType;
  data.categoryUrl = categoryUrl;
  await load$1(event);
  return { ...data, sidebar: ProfileSidebar };
}
function Tickets_1($$payload, $$props) {
  push();
  var $$store_subs;
  let data = $$props["data"];
  $$payload.out += `<div class="card"><div class="card-body"><div class="row justify-content-between pb-3 align-items-center"><div class="col-auto"><h4 class="card-title mb-md-0">`;
  if (data.categoryUrl) {
    $$payload.out += "<!--[-->";
    $$payload.out += `${html(store_get($$store_subs ??= {}, "$_", $format)("pages.category-tickets.title", {
      values: {
        categoryName: `<strong
            >"${data.category.title === "-" ? store_get($$store_subs ??= {}, "$_", $format)("pages.category-tickets.no-category") : data.category.title}"</strong>`
      }
    }))}`;
  } else {
    $$payload.out += "<!--[!-->";
    $$payload.out += `${escape_html(store_get($$store_subs ??= {}, "$_", $format)("pages.tickets.title"))}`;
  }
  $$payload.out += `<!--]--></h4></div> `;
  if (!data.categoryUrl) {
    $$payload.out += "<!--[-->";
    $$payload.out += `<div class="col-md-auto col-12 text-md-right text-center"><div class="btn-group"><a${attr_class("btn btn-sm btn-outline-light btn-link", void 0, { "active": data.pageType === PageTypes.ALL })} role="button" href="/tickets">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("pages.tickets.all"))}</a> <a${attr_class("btn btn-sm btn-outline-light btn-link text-danger", void 0, { "active": data.pageType === PageTypes.CLOSED })} role="button" href="?pageType=CLOSED">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("pages.tickets.closed"))}</a></div></div>`;
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]--></div> `;
  Tickets($$payload, { tickets: data.tickets });
  $$payload.out += `<!----></div></div> <br/> `;
  if (data.ticketCount > 0) {
    $$payload.out += "<!--[-->";
    Pagination($$payload, { page: data.page, totalPage: data.totalPage, loading: false });
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]-->`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  bind_props($$props, { data });
  pop();
}

var _page = /*#__PURE__*/Object.freeze({
  __proto__: null,
  load: load
});

const index = 19;
let component_cache;
const component = async () => component_cache ??= (await import('./_page.svelte-BZDXpRCQ.js')).default;
const universal_id = "src/routes/tickets/+page.js";
const imports = ["_app/immutable/nodes/19.vCDpzN19.js","_app/immutable/chunks/NZTpNUN0.js","_app/immutable/chunks/A5Q-2kZ4.js","_app/immutable/chunks/D5TKtvHY.js","_app/immutable/chunks/fllelwxA.js","_app/immutable/chunks/Cd5_9v32.js","_app/immutable/chunks/qMI2V-ei.js","_app/immutable/chunks/DKsB_7LU.js","_app/immutable/chunks/B47GiyGV.js","_app/immutable/chunks/CP7Uhx1M.js","_app/immutable/chunks/Bt91i2nN.js","_app/immutable/chunks/0nBbjdj7.js","_app/immutable/chunks/XSHPCi-H.js","_app/immutable/chunks/BXqfVL7H.js","_app/immutable/chunks/tAItdJCZ.js","_app/immutable/chunks/Dwj-0-pM.js","_app/immutable/chunks/DpYKOcCi.js","_app/immutable/chunks/B0OlVNmS.js","_app/immutable/chunks/BBdd__bl.js","_app/immutable/chunks/C52Z-krK.js","_app/immutable/chunks/Cj5Xjk0G.js","_app/immutable/chunks/0QwLbeAv.js","_app/immutable/chunks/IHkhavGh.js","_app/immutable/chunks/BM7PG59K.js","_app/immutable/chunks/D5Za9yOS.js","_app/immutable/chunks/BqE1et2F.js","_app/immutable/chunks/V8QYqjjF.js"];
const stylesheets = [];
const fonts = [];

var _19 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  component: component,
  fonts: fonts,
  imports: imports,
  index: index,
  stylesheets: stylesheets,
  universal: _page,
  universal_id: universal_id
});

export { Tickets_1 as T, _19 as _ };
//# sourceMappingURL=19-BgBBcA2P.js.map
