import { V as escape_html, W as store_get, X as unsubscribe_stores, T as bind_props, n as pop, $ as ensure_array_like, p as push } from './exports-Do6ngivA.js';
import './client-BeMlZc74.js';
import { P as Pagination } from './Pagination-DZqFhXsC.js';
import { g as getPosts, P as Post } from './posts-BTMoHU4r.js';
import { N as NoContent } from './NoContent-CHLPGKcG.js';
import { e as error } from './index2-DzcLzHBX.js';
import { $ as $format } from './runtime-tSokRynY.js';
import { l as load$1, H as HomeSidebar } from './HomeSidebar-COSg5sZz.js';

function Posts($$payload, $$props) {
  let posts = $$props["posts"];
  const each_array = ensure_array_like(posts);
  if (each_array.length !== 0) {
    $$payload.out += "<!--[-->";
    for (let index = 0, $$length = each_array.length; index < $$length; index++) {
      let post = each_array[index];
      Post($$payload, { post });
    }
  } else {
    $$payload.out += "<!--[!-->";
    NoContent($$payload, {});
  }
  $$payload.out += `<!--]-->`;
  bind_props($$props, { posts });
}
async function load(event) {
  const { parent, url: { searchParams } } = event;
  await parent();
  const page = parseInt(searchParams.get("page")) || 1;
  const categoryUrl = searchParams.get("category");
  const data = await getPosts({ page, categoryUrl, request: event });
  if (data.error) {
    if (data.error === "PAGE_NOT_FOUND" || data.error === "NOT_EXISTS") {
      throw error(404, data.error);
    }
    throw error(500, data.error);
  }
  data.page = page;
  data.categoryUrl = categoryUrl;
  if (!categoryUrl) {
    await load$1(event);
  }
  return { ...data, sidebar: categoryUrl ? null : HomeSidebar };
}
function Home($$payload, $$props) {
  push();
  var $$store_subs;
  let data = $$props["data"];
  if (data.categoryUrl) {
    $$payload.out += "<!--[-->";
    $$payload.out += `<div class="row justify-content-between mb-3"><div class="col-auto"><h4>${escape_html(store_get($$store_subs ??= {}, "$_", $format)("pages.category-posts.title", {
      values: {
        categoryTitle: data.category.title,
        postCount: data.postCount
      }
    }))}</h4></div> <div class="col-auto"><a href="/"><i class="fas fa-arrow-left me-2"></i> ${escape_html(store_get($$store_subs ??= {}, "$_", $format)("pages.category-posts.posts"))}</a></div></div>`;
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]--> `;
  Posts($$payload, { posts: data.posts });
  $$payload.out += `<!---->  `;
  if (data.postCount > 0) {
    $$payload.out += "<!--[-->";
    Pagination($$payload, { page: data.page, totalPage: data.totalPage, loading: false });
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]-->`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  bind_props($$props, { data });
  pop();
}

var _page = /*#__PURE__*/Object.freeze({
  __proto__: null,
  load: load
});

const index = 5;
let component_cache;
const component = async () => component_cache ??= (await import('./_page.svelte-BnjpX16m.js')).default;
const universal_id = "src/routes/+page.js";
const imports = ["_app/immutable/nodes/5.DRjXPaha.js","_app/immutable/chunks/NZTpNUN0.js","_app/immutable/chunks/A5Q-2kZ4.js","_app/immutable/chunks/D5TKtvHY.js","_app/immutable/chunks/fllelwxA.js","_app/immutable/chunks/Cd5_9v32.js","_app/immutable/chunks/B47GiyGV.js","_app/immutable/chunks/CP7Uhx1M.js","_app/immutable/chunks/B95ywDpC.js","_app/immutable/chunks/D5Za9yOS.js","_app/immutable/chunks/0nBbjdj7.js","_app/immutable/chunks/XSHPCi-H.js","_app/immutable/chunks/DpYKOcCi.js","_app/immutable/chunks/BXqfVL7H.js","_app/immutable/chunks/tAItdJCZ.js","_app/immutable/chunks/C52Z-krK.js","_app/immutable/chunks/Cj5Xjk0G.js","_app/immutable/chunks/DKsB_7LU.js","_app/immutable/chunks/UbinW0dQ.js","_app/immutable/chunks/qMI2V-ei.js","_app/immutable/chunks/BqE1et2F.js","_app/immutable/chunks/B0OlVNmS.js","_app/immutable/chunks/BBdd__bl.js","_app/immutable/chunks/BM7PG59K.js","_app/immutable/chunks/V8QYqjjF.js"];
const stylesheets = [];
const fonts = [];

var _5 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  component: component,
  fonts: fonts,
  imports: imports,
  index: index,
  stylesheets: stylesheets,
  universal: _page,
  universal_id: universal_id
});

export { Home as H, _5 as _ };
//# sourceMappingURL=5-vhxN9Npt.js.map
