import { K as writable, a2 as get, $ as ensure_array_like, W as store_get, V as escape_html, _ as attr_class, X as unsubscribe_stores, T as bind_props, n as pop, p as push, Z as attr } from './exports-Do6ngivA.js';
import { o as onDestroy } from './index-server-DUEkhmS8.js';
import { $ as $format } from './runtime-tSokRynY.js';
import { l as locales, c as currentLanguage } from './language.util-CDe4A5iH.js';
import './client-BeMlZc74.js';
import './index2-DzcLzHBX.js';
import { N as NoContent } from './NoContent-CHLPGKcG.js';
import { b as ApiUtil } from './api.util-D2jxxvoB.js';
import { r as requireLogin } from './Store-CyzmPbdB.js';
import { f as formatDistanceToNow } from './formatDistanceToNow-CrEeDtkH.js';

const dialogID = "confirmDeleteAllNotifications";
function ConfirmRemoveAllNotificationsModal($$payload, $$props) {
  push();
  var $$store_subs;
  let loading;
  $$payload.out += `<div aria-hidden="true" class="modal fade"${attr("id", dialogID)} role="dialog" tabindex="-1"><div class="modal-dialog modal-dialog-centered" role="dialog"><div class="modal-content"><div class="modal-body text-center"><div class="pb-3"><i class="fas fa-question-circle fa-3x d-block m-auto text-gray"></i></div> ${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.modals.confirm-remove-all-notifications.title"))}</div> <div class="modal-footer flex-nowrap"><button${attr_class("btn btn-link col-6 m-0", void 0, { "disabled": loading })} type="button"${attr("aria-disabled", loading)}${attr("disabled", loading, true)}>${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.modals.confirm-remove-all-notifications.cancel-button"))}</button> <button${attr_class("btn btn-danger col-6 m-0", void 0, { "disabled": loading })} type="button"${attr("aria-disabled", loading)}${attr("disabled", loading, true)}>${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.modals.confirm-remove-all-notifications.yes-button"))}</button></div></div></div></div>`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  pop();
}
const notifications = writable([]);
const count = writable(0);
Array.prototype.insert = function(index, item) {
  this.splice(index, 0, item);
  return this;
};
Array.prototype.remove = function(index) {
  this.splice(index, 1);
  return this;
};
function setNotifications(newNotifications) {
  if (get(notifications).length === 0 || newNotifications.length === 0) notifications.set(newNotifications);
  else {
    const listOfFilterIsNotificationExists = [];
    newNotifications.forEach((item, index) => {
      listOfFilterIsNotificationExists[index] = get(notifications).filter((filterItem) => filterItem.id === item.id);
    });
    newNotifications.forEach((item, index) => {
      if (listOfFilterIsNotificationExists[index].length === 0) {
        notifications.set(get(notifications).insert(index, item));
      }
    });
  }
}
async function loadData({ request }) {
  return new Promise((resolve, reject) => {
    ApiUtil.get({ path: "/api/notifications", request }).then((body) => {
      if (body.result === "ok") {
        resolve(body);
      } else {
        reject(body);
      }
    });
  });
}
async function load(event) {
  const { parent } = event;
  const parentData = await parent();
  const { session } = parentData;
  requireLogin(session);
  let data = {};
  await loadData({ request: event }).then((body) => {
    setNotifications(body.notifications);
    count.set(parseInt(body.notificationCount));
  });
  return data;
}
function Notifications($$payload, $$props) {
  push();
  var $$store_subs;
  let data = $$props["data"];
  let page = 0;
  let loadMoreLoading = false;
  let checkTime = 0;
  let interval;
  function stopNotificationsCountdown() {
    clearInterval(interval);
  }
  function getTime(check, time, locale) {
    return formatDistanceToNow(time, { addSuffix: true, locale });
  }
  onDestroy(() => {
    stopNotificationsCountdown();
  });
  const each_array = ensure_array_like(store_get($$store_subs ??= {}, "$notifications", notifications));
  $$payload.out += `<div class="container"><div class="row justify-content-end mb-3 animate__animated animate__slideInUp">`;
  if (store_get($$store_subs ??= {}, "$notifications", notifications).length !== 0) {
    $$payload.out += "<!--[-->";
    $$payload.out += `<div class="col-auto"><button type="button" class="btn btn-danger">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("pages.notifications.delete-all-button"))}</button></div>`;
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]--></div> <div class="card"><div class="card-body"><h3 class="card-title">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("navbar.notifications.title"))}</h3> <!--[-->`;
  for (let index = 0, $$length = each_array.length; index < $$length; index++) {
    let notification = each_array[index];
    $$payload.out += `<div class="list-group list-group-flush"><a href="javascript:void(0);"${attr_class("list-group-item list-group-item-action", void 0, { "notification-unread": notification.status === "NOT_READ" })}><span class="text-wrap">${escape_html(notification.type)}</span> <br/> <small class="text-muted">${escape_html(getTime(checkTime, parseInt(notification.date), locales[store_get($$store_subs ??= {}, "$currentLanguage", currentLanguage).dateFnsCode]))}</small></a> <button class="btn-close btn-sm mx-2"></button></div>`;
  }
  $$payload.out += `<!--]--> `;
  if (store_get($$store_subs ??= {}, "$notifications", notifications).length === 0) {
    $$payload.out += "<!--[-->";
    NoContent($$payload, {});
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]--> `;
  if (store_get($$store_subs ??= {}, "$notifications", notifications).length < store_get($$store_subs ??= {}, "$count", count) && store_get($$store_subs ??= {}, "$count", count) > 10 + 10 * page) {
    $$payload.out += "<!--[-->";
    $$payload.out += `<div class="mt-3"><button${attr_class("btn btn-link bg-light d-block m-auto", void 0, { "disabled": loadMoreLoading })}>${escape_html(store_get($$store_subs ??= {}, "$_", $format)("pages.notifications.show-more", {
      values: {
        count: store_get($$store_subs ??= {}, "$count", count) - store_get($$store_subs ??= {}, "$notifications", notifications).length
      }
    }))}</button></div>`;
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]--></div></div></div> `;
  ConfirmRemoveAllNotificationsModal($$payload);
  $$payload.out += `<!---->`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  bind_props($$props, { data });
  pop();
}

var _page = /*#__PURE__*/Object.freeze({
  __proto__: null,
  load: load
});

const index = 8;
let component_cache;
const component = async () => component_cache ??= (await import('./_page.svelte-DMn7Gx1d.js')).default;
const universal_id = "src/routes/notifications/+page.js";
const imports = ["_app/immutable/nodes/8.HwqJdPda.js","_app/immutable/chunks/NZTpNUN0.js","_app/immutable/chunks/A5Q-2kZ4.js","_app/immutable/chunks/D5TKtvHY.js","_app/immutable/chunks/fllelwxA.js","_app/immutable/chunks/Cd5_9v32.js","_app/immutable/chunks/D5Za9yOS.js","_app/immutable/chunks/0nBbjdj7.js","_app/immutable/chunks/XSHPCi-H.js","_app/immutable/chunks/DKsB_7LU.js","_app/immutable/chunks/B47GiyGV.js","_app/immutable/chunks/CP7Uhx1M.js","_app/immutable/chunks/BXqfVL7H.js","_app/immutable/chunks/tAItdJCZ.js","_app/immutable/chunks/B0OlVNmS.js","_app/immutable/chunks/DpYKOcCi.js","_app/immutable/chunks/DVC5Gnwt.js","_app/immutable/chunks/V8QYqjjF.js","_app/immutable/chunks/Cj5Xjk0G.js"];
const stylesheets = [];
const fonts = [];

var _8 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  component: component,
  fonts: fonts,
  imports: imports,
  index: index,
  stylesheets: stylesheets,
  universal: _page,
  universal_id: universal_id
});

export { Notifications as N, _8 as _ };
//# sourceMappingURL=8-D62e1ZW_.js.map
