import { T as bind_props, n as pop, V as escape_html, W as store_get, X as unsubscribe_stores, K as writable, p as push } from './exports-Do6ngivA.js';
import { $ as $format } from './runtime-tSokRynY.js';
import { D as Date_1 } from './Date-B9qW_84W.js';
import { e as error } from './index2-DzcLzHBX.js';
import { o as onDestroy } from './index-server-DUEkhmS8.js';
import { S as Sidebar } from './Sidebar-CxRGxZkf.js';
import { P as PlayerHead, a as PlayerPermissionBadge } from './PlayerHead-DDkUgZmg.js';
import { b as ApiUtil } from './api.util-D2jxxvoB.js';
import { g as getPlayerProfile } from './profile2-C83lZb9Z.js';

const data = writable({
  username: "",
  lastActivityTime: 0,
  inGame: false,
  permissionGroupName: ""
});
const load$1 = async (event) => {
  data.set({
    ...await ApiUtil.get({
      path: `/api/sidebars/profile/${event.params.player}`,
      request: event
    }),
    username: event.params.player
  });
};
String.prototype.capitalize = function() {
  return this.charAt(0).toUpperCase() + this.slice(1);
};
function PlayerProfileSidebar($$payload, $$props) {
  push();
  var $$store_subs;
  let checkTime = 0;
  let interval;
  let side = $$props["side"];
  onDestroy(() => {
    clearInterval(interval);
  });
  Sidebar($$payload, {
    side,
    children: ($$payload2) => {
      $$payload2.out += `<div class="mb-3"><div class="card"><div class="card-body">`;
      PlayerHead($$payload2, {
        username: store_get($$store_subs ??= {}, "$data", data).username,
        inGame: store_get($$store_subs ??= {}, "$data", data).inGame,
        lastActivityTime: store_get($$store_subs ??= {}, "$data", data).lastActivityTime,
        checkTime
      });
      $$payload2.out += `<!----> <div class="text-center"><h2 class="my-3">${escape_html(store_get($$store_subs ??= {}, "$data", data).username)}</h2> `;
      PlayerPermissionBadge($$payload2, {
        permissionGroupName: store_get($$store_subs ??= {}, "$data", data).permissionGroupName
      });
      $$payload2.out += `<!----></div></div></div></div>`;
    },
    $$slots: { default: true }
  });
  if ($$store_subs) unsubscribe_stores($$store_subs);
  bind_props($$props, { side });
  pop();
}
async function load(event) {
  const { parent } = event;
  await parent();
  let data2 = { registerDate: 0 };
  await load$1(event);
  await getPlayerProfile({ username: event.params.player, request: event }).then((body) => {
    if (body.error) {
      if (body.error === "NOT_EXISTS") {
        throw error(404, body.error);
      }
      throw error(500, body.error);
    }
    data2 = body;
  });
  return {
    ...data2,
    sidebar: PlayerProfileSidebar,
    sidebarProps: { side: "left" }
  };
}
function PlayerProfile($$payload, $$props) {
  push();
  var $$store_subs;
  let data2 = $$props["data"];
  $$payload.out += `<div class="card"><div class="card-body"><h4 class="card-title">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("pages.player-profile.title"))}</h4> <table class="table mb-0"><tbody><tr><td>${escape_html(store_get($$store_subs ??= {}, "$_", $format)("pages.player-profile.register-date"))}</td><td>`;
  Date_1($$payload, { time: data2.registerDate });
  $$payload.out += `<!----></td></tr></tbody></table></div></div>`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  bind_props($$props, { data: data2 });
  pop();
}

var _page = /*#__PURE__*/Object.freeze({
  __proto__: null,
  load: load
});

const index = 9;
let component_cache;
const component = async () => component_cache ??= (await import('./_page.svelte-zvyb_vSc.js')).default;
const universal_id = "src/routes/player/[player]/+page.js";
const imports = ["_app/immutable/nodes/9.8IZtaFLV.js","_app/immutable/chunks/NZTpNUN0.js","_app/immutable/chunks/A5Q-2kZ4.js","_app/immutable/chunks/D5TKtvHY.js","_app/immutable/chunks/fllelwxA.js","_app/immutable/chunks/B47GiyGV.js","_app/immutable/chunks/CP7Uhx1M.js","_app/immutable/chunks/BXqfVL7H.js","_app/immutable/chunks/C52Z-krK.js","_app/immutable/chunks/Cj5Xjk0G.js","_app/immutable/chunks/DKsB_7LU.js","_app/immutable/chunks/Dwj-0-pM.js","_app/immutable/chunks/Cd5_9v32.js","_app/immutable/chunks/tAItdJCZ.js","_app/immutable/chunks/0nBbjdj7.js","_app/immutable/chunks/XSHPCi-H.js","_app/immutable/chunks/DpYKOcCi.js","_app/immutable/chunks/B0OlVNmS.js","_app/immutable/chunks/BBdd__bl.js","_app/immutable/chunks/CkNdniQD.js","_app/immutable/chunks/BqE1et2F.js"];
const stylesheets = [];
const fonts = [];

var _9 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  component: component,
  fonts: fonts,
  imports: imports,
  index: index,
  stylesheets: stylesheets,
  universal: _page,
  universal_id: universal_id
});

export { PlayerProfile as P, _9 as _ };
//# sourceMappingURL=9-DwgYyltU.js.map
