import { p as push, a3 as fallback, $ as ensure_array_like, _ as attr_class, Z as attr, V as escape_html, T as bind_props, n as pop } from './exports-Do6ngivA.js';

function Pagination($$payload, $$props) {
  push();
  let pages;
  let page = $$props["page"];
  let loading = fallback($$props["loading"], false);
  let totalPage = fallback($$props["totalPage"], 1);
  {
    pages = [];
    for (let i = 1; i <= totalPage; i++) {
      pages.push(i);
    }
  }
  const each_array = ensure_array_like(pages);
  $$payload.out += `<nav><ul class="pagination justify-content-center"><li${attr_class("page-item", void 0, { "disabled": parseInt(page) === 1 || loading })}><a class="page-link" href="javascript:void(0);"${attr("aria-hidden", parseInt(page) === 1 || loading)}><i class="fa-solid fa-caret-left"></i></a></li> <!--[-->`;
  for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
    let index = each_array[$$index];
    $$payload.out += `<li${attr_class("page-item", void 0, {
      "active": parseInt(page) === index,
      "disabled": parseInt(page) !== index && loading
    })}${attr("aria-current", parseInt(page) === index ? "page" : "")}><a class="page-link" href="javascript:void(0);"${attr("aria-hidden", parseInt(page) === index)}>${escape_html(index)}</a></li>`;
  }
  $$payload.out += `<!--]--> <li${attr_class("page-item", void 0, { "disabled": parseInt(page) === totalPage || loading })}><a class="page-link"${attr("aria-hidden", parseInt(page) === totalPage || loading)} href="javascript:void(0);"><i class="fa-solid fa-caret-right"></i></a></li></ul></nav>`;
  bind_props($$props, { page, loading, totalPage });
  pop();
}

export { Pagination as P };
//# sourceMappingURL=Pagination-DZqFhXsC.js.map
