import { p as push, V as escape_html, W as store_get, X as unsubscribe_stores, T as bind_props, n as pop, a3 as fallback, Z as attr, a0 as stringify, _ as attr_class } from './exports-Do6ngivA.js';
import { $ as $format } from './runtime-tSokRynY.js';
import './client-BeMlZc74.js';
import './index2-DzcLzHBX.js';

String.prototype.capitalize = function() {
  return this.charAt(0).toUpperCase() + this.slice(1);
};
function PlayerPermissionBadge($$payload, $$props) {
  push();
  var $$store_subs;
  let permissionGroupName = $$props["permissionGroupName"];
  $$payload.out += `<span class="badge rounded-pill text-bg-light">`;
  if (permissionGroupName) {
    $$payload.out += "<!--[-->";
    $$payload.out += `${escape_html(permissionGroupName.capitalize())}`;
  } else {
    $$payload.out += "<!--[!-->";
    $$payload.out += `${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.player-permission-badge.player"))}`;
  }
  $$payload.out += `<!--]--></span>`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  bind_props($$props, { permissionGroupName });
  pop();
}
function PlayerHead($$payload, $$props) {
  push();
  let isOnline;
  let username = $$props["username"];
  let width = fallback($$props["width"], 64);
  let height = fallback($$props["height"], 64);
  let checkTime = $$props["checkTime"];
  let inGame = fallback($$props["inGame"], false);
  let lastActivityTime = $$props["lastActivityTime"];
  String.prototype.capitalize = function() {
    return this.charAt(0).toUpperCase() + this.slice(1);
  };
  isOnline = lastActivityTime > Date.now() - 5 * 60 * 1e3 || inGame;
  if (lastActivityTime) {
    $$payload.out += "<!--[-->";
    $$payload.out += `<img${attr("src", `https://minotar.net/avatar/${stringify(username)}`)}${attr_class("rounded d-block m-auto", void 0, {
      "border": isOnline,
      "border-5": isOnline,
      "border-success": isOnline
    })}${attr("width", width)}${attr("height", height)}${attr("alt", username)} onload="this.__e=event" onerror="this.__e=event"/>`;
  } else {
    $$payload.out += "<!--[!-->";
    $$payload.out += `<img${attr("src", `https://minotar.net/avatar/${stringify(username)}`)} class="rounded d-block m-auto"${attr("width", width)}${attr("height", height)}${attr("alt", username)}/>`;
  }
  $$payload.out += `<!--]-->`;
  bind_props($$props, { username, width, height, checkTime, inGame, lastActivityTime });
  pop();
}

export { PlayerHead as P, PlayerPermissionBadge as a };
//# sourceMappingURL=PlayerHead-DDkUgZmg.js.map
