import { d as buildQueryParams, b as ApiUtil } from './api.util-D2jxxvoB.js';
import { p as push, a3 as fallback, V as escape_html, W as store_get, X as unsubscribe_stores, T as bind_props, n as pop } from './exports-Do6ngivA.js';
import { $ as $format } from './runtime-tSokRynY.js';

const getTickets = async ({ page, pageType, categoryUrl, request, csrfToken }) => {
  const queryParams = buildQueryParams({ page, pageType, categoryUrl });
  return ApiUtil.get({
    path: `/api/tickets${queryParams}`,
    request,
    csrfToken
  }).then((body) => {
    body.page = parseInt(page);
    body.pageType = pageType;
    return body;
  });
};
const getTicketCategories = async ({ page, request, csrfToken }) => {
  return ApiUtil.get({
    path: `/api/ticket/categories?page=${page}`,
    request,
    csrfToken
  }).then((body) => {
    body.page = parseInt(page);
    return body;
  });
};
const getTicketDetail = async ({ id, request, csrfToken }) => {
  return ApiUtil.get({
    path: `/api/tickets/${id}`,
    request,
    csrfToken
  });
};
const TicketStatuses = Object.freeze({ NEW: "NEW", REPLIED: "REPLIED", CLOSED: "CLOSED" });
function TicketStatus($$payload, $$props) {
  push();
  var $$store_subs;
  let status = fallback($$props["status"], () => TicketStatuses.NEW, true);
  if (status === TicketStatuses.NEW) {
    $$payload.out += "<!--[-->";
    $$payload.out += `<span class="badge text-bg-success rounded-pill">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("ticket-statuses.new"))}</span>`;
  } else if (status === TicketStatuses.REPLIED) {
    $$payload.out += "<!--[1-->";
    $$payload.out += `<span class="badge text-bg-warning rounded-pill">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("ticket-statuses.replied"))}</span>`;
  } else if (status === TicketStatuses.CLOSED) {
    $$payload.out += "<!--[2-->";
    $$payload.out += `<span class="badge text-bg-danger rounded-pill">${escape_html(store_get($$store_subs ??= {}, "$_", $format)("ticket-statuses.closed"))}</span>`;
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]-->`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  bind_props($$props, { status });
  pop();
}

export { TicketStatuses as T, TicketStatus as a, getTicketCategories as b, getTickets as c, getTicketDetail as g };
//# sourceMappingURL=TicketStatus-Cqgq9C2b.js.map
