import { a2 as get, F as DEV } from './exports-Do6ngivA.js';
import './client-BeMlZc74.js';
import { i as initialized } from './Store-CyzmPbdB.js';

const browser = DEV;
let API_URL = "http://localhost:8088/api";
const PANEL_URL = "/panel";
const COOKIE_PREFIX = "pano_";
const CSRF_TOKEN_COOKIE_NAME = "csrf_token";
const JWT_COOKIE_NAME = "auth_token";
const CSRF_HEADER = "X-CSRF-Token";
const PLUGIN_DEV_MODE = "false"?.toLowerCase() === "true";
function updateApiUrl(apiUrl) {
  API_URL = apiUrl;
}
function buildQueryParams(params) {
  const queryString = Object.keys(params).filter((key) => params[key]).map((key) => `${encodeURIComponent(key)}=${encodeURIComponent(params[key])}`).join("&");
  return queryString === "" ? "" : "?" + queryString;
}
const ApiUtil = {
  interceptors: {},
  // GET request
  async get({ path, request, csrfToken, token, blob, handler }) {
    return this.customRequest({ path, request, csrfToken, token, blob, handler });
  },
  // POST request
  async post({ path, request, body, headers, csrfToken, token, blob, handler }) {
    return this.customRequest({
      path,
      data: { method: "POST", credentials: "include", body, headers },
      request,
      csrfToken,
      token,
      blob,
      handler
    });
  },
  // PUT request
  async put({ path, request, body, headers, csrfToken, token, blob, handler }) {
    return this.customRequest({
      path,
      data: { method: "PUT", credentials: "include", body, headers },
      request,
      csrfToken,
      token,
      blob,
      handler
    });
  },
  // DELETE request
  async delete({ path, request, headers, csrfToken, token, blob, handler }) {
    return this.customRequest({
      path,
      data: { method: "DELETE", headers },
      request,
      csrfToken,
      token,
      blob,
      handler
    });
  },
  // Custom request handler
  async customRequest({ path, data = {}, request, csrfToken, token, blob, handler }) {
    if (!csrfToken) {
      let session;
      if (request) {
        const parentData = await request.parent();
        session = parentData.session;
      }
      csrfToken = session && session.csrfToken;
    }
    const CSRFHeader = csrfToken ? { [CSRF_HEADER]: csrfToken } : {};
    if (!(data.body instanceof FormData)) {
      data.body = JSON.stringify(data.body);
      data.headers = { "Content-Type": "application/json", ...data.headers };
    }
    const options = {
      ...data,
      headers: { ...data.headers, ...CSRFHeader }
    };
    if (token) {
      options.headers["Authorization"] = `Bearer ${token}`;
    } else if ("credentials" in Request.prototype) {
      options["credentials"] = "include";
    }
    if (request && !get(initialized) || !browser || API_URL.includes(".panomc.com")) {
      const apiUrl = !API_URL.includes(".panomc.com") && true && browser ? "/api" : API_URL;
      path = `${apiUrl}/${path.replace("/api/", "")}`;
    }
    const bodyHandler = (response) => blob ? response.blob() : response.text();
    const jsonParseHandler = (json) => {
      try {
        return JSON.parse(json);
      } catch (err) {
        return json;
      }
    };
    const requestCall = (rejectHandler) => {
      const fetchMethod = request && request.fetch ? request.fetch(path, options) : fetch(path, options);
      const reject = async (err) => {
        console.log(err);
        if (rejectHandler) {
          throw new Error(err);
        }
        if (!this.interceptors.errorHandler || !handler) {
          return;
        }
        this.interceptors.errorHandler(requestCall);
      };
      return fetchMethod.then(bodyHandler).then(jsonParseHandler).then(async (parsedJson) => handler ? await handler(parsedJson, reject) : parsedJson).catch(reject);
    };
    return requestCall();
  }
};

export { API_URL as A, COOKIE_PREFIX as C, JWT_COOKIE_NAME as J, PANEL_URL as P, CSRF_TOKEN_COOKIE_NAME as a, ApiUtil as b, PLUGIN_DEV_MODE as c, buildQueryParams as d, updateApiUrl as u };
//# sourceMappingURL=api.util-D2jxxvoB.js.map
