import { p as push, a3 as fallback, Z as attr, a0 as stringify, V as escape_html, W as store_get, X as unsubscribe_stores, T as bind_props, n as pop } from './exports-Do6ngivA.js';
import { $ as $format } from './runtime-tSokRynY.js';
import './client-BeMlZc74.js';
import { D as Date_1 } from './Date-B9qW_84W.js';
import { h as html } from './html-FW6Ia4bL.js';
import { d as buildQueryParams, b as ApiUtil } from './api.util-D2jxxvoB.js';

function truncate(str, n) {
  return str.length > n ? str.substr(0, n - 1) : str;
}
function Post($$payload, $$props) {
  push();
  var $$store_subs;
  let post = $$props["post"];
  let detail = fallback($$props["detail"], false);
  $$payload.out += `<div class="card mb-3">`;
  if (post.thumbnailUrl) {
    $$payload.out += "<!--[-->";
    $$payload.out += `<a${attr("href", `/post/${stringify(post.url)}`)}><img${attr("src", post.thumbnailUrl)} class="card-img-top rounded-top"${attr("alt", post.title)}${attr("title", post.title)}/></a>`;
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]--> <div class="card-body"><div class="row mb-3 justify-content-center"><div class="col"><a class="card-title text-black"${attr("href", `/post/${stringify(post.url)}`)}><h3 class="mb-0 d-inline-block text-break">${escape_html(truncate(post.title, 100))}${html(post.title.length > 100 ? "&hellip;" : "")}</h3></a></div> <div class="col-auto">`;
  if (post.category.title !== "-") {
    $$payload.out += "<!--[-->";
    $$payload.out += `<a class="badge bg-secondary text-dark rounded-pill"${attr("href", `?category=${stringify(post.category.url)}`)}>${escape_html(post.category.title)}</a>`;
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]--></div></div> <div class="card-text text-break">${html(post.text)}</div></div> <div class="card-footer bg-white d-flex align-items-center justify-content-between">`;
  if (detail) {
    $$payload.out += "<!--[-->";
    $$payload.out += `<ul class="m-0 p-0 text-muted"><li class="list-inline"><div class="list-inline-item px-1"><i class="fas fa-eye me-2"></i> ${escape_html(post.views)}</div></li></ul> <div>`;
    Date_1($$payload, { time: post.date });
    $$payload.out += `<!----> <a${attr("href", `/player/${stringify(post.writer.username)}`)}><img${attr("src", `https://minotar.net/avatar/${stringify(post.writer.username)}`)}${attr("alt", post.writer.username)} width="32" height="32" class="rounded-circle ms-2" onload="this.__e=event" onerror="this.__e=event"/></a></div>`;
  } else {
    $$payload.out += "<!--[!-->";
    $$payload.out += `<a${attr("href", `/post/${stringify(post.url)}`)}>${escape_html(store_get($$store_subs ??= {}, "$_", $format)("components.post.read-more"))}</a> <div>`;
    Date_1($$payload, { time: post.date });
    $$payload.out += `<!----> <a${attr("href", `/player/${stringify(post.writer.username)}`)}><img${attr("src", `https://minotar.net/avatar/${stringify(post.writer.username)}`)}${attr("alt", post.writer.username)} width="32" height="32" class="rounded-circle ms-2" onload="this.__e=event" onerror="this.__e=event"/></a></div>`;
  }
  $$payload.out += `<!--]--></div></div>`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  bind_props($$props, { post, detail });
  pop();
}
const getPosts = async ({ page, categoryUrl, request, csrfToken }) => {
  const queryParams = buildQueryParams({ page, categoryUrl });
  return ApiUtil.get({
    path: `/api/posts${queryParams}`,
    request,
    csrfToken
  }).then((body) => {
    body.page = parseInt(page);
    return body;
  });
};
const getPostDetail = async ({ url, request, csrfToken }) => {
  return ApiUtil.post({
    path: `/api/posts/${url}`,
    request,
    csrfToken
  }).then((body) => {
    body.url = url;
    return body;
  });
};
const getPostPreview = async ({ id, request, csrfToken }) => {
  return ApiUtil.get({
    path: `/api/panel/posts/${id}/preview`,
    request,
    csrfToken
  }).then((body) => {
    body.id = parseInt(id);
    return body;
  });
};

export { Post as P, getPostDetail as a, getPostPreview as b, getPosts as g };
//# sourceMappingURL=posts-BTMoHU4r.js.map
