/*
 * Decompiled with CFR 0.152.
 */
package com.panomc.plugins.announcement.routes.api;

import com.panomc.platform.annotation.Endpoint;
import com.panomc.platform.db.DatabaseManager;
import com.panomc.platform.model.Api;
import com.panomc.platform.model.Path;
import com.panomc.platform.model.Result;
import com.panomc.platform.model.RouteType;
import com.panomc.platform.util.MimeTypeUtil;
import com.panomc.plugins.announcement.AnnouncementPlugin;
import com.panomc.plugins.announcement.db.dao.AnnouncementDao;
import com.panomc.plugins.announcement.db.model.Announcement;
import com.panomc.plugins.announcement.routes.api.GetAnnouncementImageAPI;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.validation.RequestParameters;
import io.vertx.ext.web.validation.ValidationHandler;
import io.vertx.ext.web.validation.builder.Parameters;
import io.vertx.ext.web.validation.builder.ValidationHandlerBuilder;
import io.vertx.json.schema.SchemaRepository;
import io.vertx.json.schema.common.dsl.Schemas;
import io.vertx.json.schema.common.dsl.StringSchemaBuilder;
import io.vertx.sqlclient.SqlClient;
import java.io.File;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Endpoint
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0096@\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/panomc/plugins/announcement/routes/api/GetAnnouncementImageAPI;", "Lcom/panomc/platform/model/Api;", "plugin", "Lcom/panomc/plugins/announcement/AnnouncementPlugin;", "announcementDao", "Lcom/panomc/plugins/announcement/db/dao/AnnouncementDao;", "<init>", "(Lcom/panomc/plugins/announcement/AnnouncementPlugin;Lcom/panomc/plugins/announcement/db/dao/AnnouncementDao;)V", "paths", "", "Lcom/panomc/platform/model/Path;", "getPaths", "()Ljava/util/List;", "databaseManager", "Lcom/panomc/platform/db/DatabaseManager;", "getDatabaseManager", "()Lcom/panomc/platform/db/DatabaseManager;", "databaseManager$delegate", "Lkotlin/Lazy;", "getValidationHandler", "Lio/vertx/ext/web/validation/ValidationHandler;", "schemaRepository", "Lio/vertx/json/schema/SchemaRepository;", "handle", "Lcom/panomc/platform/model/Result;", "context", "Lio/vertx/ext/web/RoutingContext;", "(Lio/vertx/ext/web/RoutingContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "pano-plugin-announcement"})
public final class GetAnnouncementImageAPI
extends Api {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnnouncementPlugin plugin;
    @NotNull
    private final AnnouncementDao announcementDao;
    @NotNull
    private final List<Path> paths;
    @NotNull
    private final Lazy databaseManager$delegate;
    private static final int CACHE_TTL_SECONDS = 604800;

    public GetAnnouncementImageAPI(@NotNull AnnouncementPlugin plugin, @NotNull AnnouncementDao announcementDao) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)((Object)announcementDao), (String)"announcementDao");
        this.plugin = plugin;
        this.announcementDao = announcementDao;
        this.paths = CollectionsKt.listOf((Object)new Path("/api/announcements/image/:fileName", RouteType.GET));
        this.databaseManager$delegate = LazyKt.lazy(() -> GetAnnouncementImageAPI.databaseManager_delegate$lambda$0(this));
    }

    @NotNull
    public List<Path> getPaths() {
        return this.paths;
    }

    private final DatabaseManager getDatabaseManager() {
        Lazy lazy = this.databaseManager$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (DatabaseManager)object;
    }

    @NotNull
    public ValidationHandler getValidationHandler(@NotNull SchemaRepository schemaRepository) {
        Intrinsics.checkNotNullParameter((Object)schemaRepository, (String)"schemaRepository");
        ValidationHandler validationHandler = ValidationHandlerBuilder.create((SchemaRepository)schemaRepository).pathParameter(Parameters.param((String)"fileName", (StringSchemaBuilder)Schemas.stringSchema())).build();
        Intrinsics.checkNotNullExpressionValue((Object)validationHandler, (String)"build(...)");
        return validationHandler;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object handle(@NotNull RoutingContext context, @NotNull Continuation<? super Result> $completion) {
        if (!($completion instanceof handle.1)) ** GOTO lbl-1000
        var13_3 = $completion;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ GetAnnouncementImageAPI this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.handle(null, (Continuation<? super Result>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                parameters = this.getParameters(context);
                fileName = parameters.pathParameter("fileName").getString();
                $continuation.L$0 = context;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)parameters);
                $continuation.L$2 = fileName;
                $continuation.label = 1;
                v0 = this.getDatabaseManager().getSqlClient((Continuation)$continuation);
                if (v0 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl28
            }
            case 1: {
                fileName = (String)$continuation.L$2;
                parameters = (RequestParameters)$continuation.L$1;
                context = (RoutingContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                sqlClient = (SqlClient)v0;
                Intrinsics.checkNotNull((Object)fileName);
                $continuation.L$0 = context;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)parameters);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)fileName);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)sqlClient);
                $continuation.label = 2;
                v1 = this.announcementDao.getByImageFileName(fileName, sqlClient, (Continuation<? super Announcement>)$continuation);
                if (v1 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl46
            }
            case 2: {
                sqlClient = (SqlClient)$continuation.L$3;
                fileName = (String)$continuation.L$2;
                parameters = (RequestParameters)$continuation.L$1;
                context = (RoutingContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl46:
                // 2 sources

                if ((announcement = (Announcement)v1) == null || announcement.getImageFileName() == null) {
                    context.response().setStatusCode(404).end();
                    return null;
                }
                if (!announcement.getStatus()) {
                    context.response().setStatusCode(404).end();
                    return null;
                }
                if (announcement.getUntil() != null) {
                    v2 = announcement.getUntil();
                    var7_13 = 0L;
                    if ((v2 == null || v2 != var7_13) && announcement.getUntil() < System.currentTimeMillis()) {
                        context.response().setStatusCode(404).end();
                        return null;
                    }
                }
                if (announcement.getShowFrom() != null && announcement.getShowFrom() > System.currentTimeMillis()) {
                    context.response().setStatusCode(404).end();
                    return null;
                }
                file = new File(this.plugin.getUploadsDir(), announcement.getImageFileName());
                if (!file.exists()) {
                    context.response().setStatusCode(404).end();
                    return null;
                }
                etag = "\"" + announcement.getId() + "-" + announcement.getImageFileName() + "\"";
                v3 = file.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getAbsolutePath(...)");
                mimeType = MimeTypeUtil.INSTANCE.getMimeTypeFromFileName(v3);
                response = context.response();
                response.putHeader("Content-Type", mimeType);
                response.putHeader("ETag", etag);
                response.putHeader("Cache-Control", "public, max-age=604800, immutable");
                try {
                    response.sendFile(file.getAbsolutePath());
                }
                catch (Exception var11_18) {
                    // empty catch block
                }
                return null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final DatabaseManager databaseManager_delegate$lambda$0(GetAnnouncementImageAPI this$0) {
        return (DatabaseManager)this$0.plugin.getApplicationContext().getBean(DatabaseManager.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/panomc/plugins/announcement/routes/api/GetAnnouncementImageAPI$Companion;", "", "<init>", "()V", "CACHE_TTL_SECONDS", "", "pano-plugin-announcement"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

