/*
 * Decompiled with CFR 0.152.
 */
package com.panomc.plugins.announcement.routes.panel;

import com.panomc.platform.annotation.Endpoint;
import com.panomc.platform.auth.AuthProvider;
import com.panomc.platform.auth.Permission;
import com.panomc.platform.db.DatabaseManager;
import com.panomc.platform.model.PanelApi;
import com.panomc.platform.model.Path;
import com.panomc.platform.model.Result;
import com.panomc.platform.model.RouteType;
import com.panomc.platform.util.MimeTypeUtil;
import com.panomc.plugins.announcement.AnnouncementPlugin;
import com.panomc.plugins.announcement.db.dao.AnnouncementDao;
import com.panomc.plugins.announcement.db.model.Announcement;
import com.panomc.plugins.announcement.permission.ManageAnnouncementsPermission;
import com.panomc.plugins.announcement.routes.panel.PanelGetAnnouncementImageAPI;
import com.panomc.plugins.announcement.util.ImageUtil;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.validation.RequestParameters;
import io.vertx.ext.web.validation.ValidationHandler;
import io.vertx.ext.web.validation.builder.Parameters;
import io.vertx.ext.web.validation.builder.ValidationHandlerBuilder;
import io.vertx.json.schema.SchemaRepository;
import io.vertx.json.schema.common.dsl.BooleanSchemaBuilder;
import io.vertx.json.schema.common.dsl.Schemas;
import io.vertx.json.schema.common.dsl.StringSchemaBuilder;
import io.vertx.sqlclient.SqlClient;
import java.io.File;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Endpoint
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0096@\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006&"}, d2={"Lcom/panomc/plugins/announcement/routes/panel/PanelGetAnnouncementImageAPI;", "Lcom/panomc/platform/model/PanelApi;", "plugin", "Lcom/panomc/plugins/announcement/AnnouncementPlugin;", "announcementDao", "Lcom/panomc/plugins/announcement/db/dao/AnnouncementDao;", "<init>", "(Lcom/panomc/plugins/announcement/AnnouncementPlugin;Lcom/panomc/plugins/announcement/db/dao/AnnouncementDao;)V", "paths", "", "Lcom/panomc/platform/model/Path;", "getPaths", "()Ljava/util/List;", "authProvider", "Lcom/panomc/platform/auth/AuthProvider;", "getAuthProvider", "()Lcom/panomc/platform/auth/AuthProvider;", "authProvider$delegate", "Lkotlin/Lazy;", "databaseManager", "Lcom/panomc/platform/db/DatabaseManager;", "getDatabaseManager", "()Lcom/panomc/platform/db/DatabaseManager;", "databaseManager$delegate", "getValidationHandler", "Lio/vertx/ext/web/validation/ValidationHandler;", "schemaRepository", "Lio/vertx/json/schema/SchemaRepository;", "handle", "Lcom/panomc/platform/model/Result;", "context", "Lio/vertx/ext/web/RoutingContext;", "(Lio/vertx/ext/web/RoutingContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getThumbnailFile", "Ljava/io/File;", "fileName", "", "Companion", "pano-plugin-announcement"})
public final class PanelGetAnnouncementImageAPI
extends PanelApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnnouncementPlugin plugin;
    @NotNull
    private final AnnouncementDao announcementDao;
    @NotNull
    private final List<Path> paths;
    @NotNull
    private final Lazy authProvider$delegate;
    @NotNull
    private final Lazy databaseManager$delegate;
    private static final int CACHE_TTL_SECONDS = 604800;

    public PanelGetAnnouncementImageAPI(@NotNull AnnouncementPlugin plugin, @NotNull AnnouncementDao announcementDao) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)((Object)announcementDao), (String)"announcementDao");
        this.plugin = plugin;
        this.announcementDao = announcementDao;
        this.paths = CollectionsKt.listOf((Object)new Path("/api/panel/announcements/image/:fileName", RouteType.GET));
        this.authProvider$delegate = LazyKt.lazy(() -> PanelGetAnnouncementImageAPI.authProvider_delegate$lambda$0(this));
        this.databaseManager$delegate = LazyKt.lazy(() -> PanelGetAnnouncementImageAPI.databaseManager_delegate$lambda$0(this));
    }

    @NotNull
    public List<Path> getPaths() {
        return this.paths;
    }

    private final AuthProvider getAuthProvider() {
        Lazy lazy = this.authProvider$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (AuthProvider)object;
    }

    private final DatabaseManager getDatabaseManager() {
        Lazy lazy = this.databaseManager$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (DatabaseManager)object;
    }

    @NotNull
    public ValidationHandler getValidationHandler(@NotNull SchemaRepository schemaRepository) {
        Intrinsics.checkNotNullParameter((Object)schemaRepository, (String)"schemaRepository");
        ValidationHandler validationHandler = ValidationHandlerBuilder.create((SchemaRepository)schemaRepository).pathParameter(Parameters.param((String)"fileName", (StringSchemaBuilder)Schemas.stringSchema())).queryParameter(Parameters.optionalParam((String)"thumbnail", (BooleanSchemaBuilder)Schemas.booleanSchema())).build();
        Intrinsics.checkNotNullExpressionValue((Object)validationHandler, (String)"build(...)");
        return validationHandler;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object handle(@NotNull RoutingContext context, @NotNull Continuation<? super Result> $completion) {
        if (!($completion instanceof handle.1)) ** GOTO lbl-1000
        var14_3 = $completion;
        if ((var14_3.label & -2147483648) != 0) {
            var14_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ PanelGetAnnouncementImageAPI this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.handle(null, (Continuation<? super Result>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = context;
                $continuation.label = 1;
                v0 = this.getAuthProvider().requirePermission((Permission)new ManageAnnouncementsPermission(), context, (Continuation)$continuation);
                if (v0 == var15_5) {
                    return var15_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                context = (RoutingContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                parameters = this.getParameters(context);
                fileName = parameters.pathParameter("fileName").getString();
                $continuation.L$0 = context;
                $continuation.L$1 = parameters;
                $continuation.L$2 = fileName;
                $continuation.label = 2;
                v1 = this.getDatabaseManager().getSqlClient((Continuation)$continuation);
                if (v1 == var15_5) {
                    return var15_5;
                }
                ** GOTO lbl38
            }
            case 2: {
                fileName = (String)$continuation.L$2;
                parameters = (RequestParameters)$continuation.L$1;
                context = (RoutingContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl38:
                // 2 sources

                sqlClient = (SqlClient)v1;
                Intrinsics.checkNotNull((Object)fileName);
                $continuation.L$0 = context;
                $continuation.L$1 = parameters;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)fileName);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)sqlClient);
                $continuation.label = 3;
                v2 = this.announcementDao.getByImageFileName(fileName, sqlClient, (Continuation<? super Announcement>)$continuation);
                if (v2 == var15_5) {
                    return var15_5;
                }
                ** GOTO lbl56
            }
            case 3: {
                sqlClient = (SqlClient)$continuation.L$3;
                fileName = (String)$continuation.L$2;
                parameters = (RequestParameters)$continuation.L$1;
                context = (RoutingContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl56:
                // 2 sources

                if ((announcement = (Announcement)v2) == null) {
                    context.response().setStatusCode(404).end();
                    return null;
                }
                v3 = parameters.queryParameter("thumbnail");
                v4 = v3 != null && (v3 = v3.getBoolean()) != null ? v3.booleanValue() : (isThumbnail = false);
                if (isThumbnail) {
                    v5 = announcement.getImageFileName();
                    Intrinsics.checkNotNull((Object)v5);
                    v6 = this.getThumbnailFile(v5);
                } else {
                    v6 = file = new File(this.plugin.getUploadsDir(), announcement.getImageFileName());
                }
                if (!file.exists()) {
                    context.response().setStatusCode(404).end();
                    return null;
                }
                etag = "\"" + announcement.getImageFileName() + "\"";
                v7 = file.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getAbsolutePath(...)");
                mimeType = MimeTypeUtil.INSTANCE.getMimeTypeFromFileName(v7);
                response = context.response();
                response.putHeader("Content-Type", mimeType);
                response.putHeader("ETag", etag);
                response.putHeader("Cache-Control", "public, max-age=604800, immutable");
                try {
                    response.sendFile(file.getAbsolutePath());
                }
                catch (Exception var12_17) {
                    // empty catch block
                }
                return null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final File getThumbnailFile(String fileName) {
        File thumbnailsDir = new File(this.plugin.getUploadsDir(), "thumbnails");
        File originalFile = new File(this.plugin.getUploadsDir(), fileName);
        if (!originalFile.exists()) {
            return originalFile;
        }
        ImageUtil.INSTANCE.generateThumbnail(originalFile, thumbnailsDir);
        File thumbnailFile = new File(thumbnailsDir, fileName);
        return thumbnailFile.exists() ? thumbnailFile : originalFile;
    }

    private static final AuthProvider authProvider_delegate$lambda$0(PanelGetAnnouncementImageAPI this$0) {
        return (AuthProvider)this$0.plugin.getApplicationContext().getBean(AuthProvider.class);
    }

    private static final DatabaseManager databaseManager_delegate$lambda$0(PanelGetAnnouncementImageAPI this$0) {
        return (DatabaseManager)this$0.plugin.getApplicationContext().getBean(DatabaseManager.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/panomc/plugins/announcement/routes/panel/PanelGetAnnouncementImageAPI$Companion;", "", "<init>", "()V", "CACHE_TTL_SECONDS", "", "pano-plugin-announcement"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

