/*
 * Decompiled with CFR 0.152.
 */
package com.panomc.plugins.slider.routes.panel;

import com.panomc.platform.annotation.Endpoint;
import com.panomc.platform.auth.AuthProvider;
import com.panomc.platform.db.DatabaseManager;
import com.panomc.platform.model.PanelApi;
import com.panomc.platform.model.Path;
import com.panomc.platform.model.Result;
import com.panomc.platform.model.RouteType;
import com.panomc.platform.util.MimeTypeUtil;
import com.panomc.plugins.slider.SliderPlugin;
import com.panomc.plugins.slider.db.dao.SliderDao;
import com.panomc.plugins.slider.util.ImageUtil;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.validation.RequestParameters;
import io.vertx.ext.web.validation.ValidationHandler;
import io.vertx.ext.web.validation.builder.Parameters;
import io.vertx.ext.web.validation.builder.ValidationHandlerBuilder;
import io.vertx.json.schema.SchemaRepository;
import io.vertx.json.schema.common.dsl.BooleanSchemaBuilder;
import io.vertx.json.schema.common.dsl.Schemas;
import io.vertx.json.schema.common.dsl.StringSchemaBuilder;
import java.io.File;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Endpoint
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0096@\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR#\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R#\u0010\u0014\u001a\n \u000f*\u0004\u0018\u00010\u00150\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Lcom/panomc/plugins/slider/routes/panel/PanelGetSliderImageAPI;", "Lcom/panomc/platform/model/PanelApi;", "plugin", "Lcom/panomc/plugins/slider/SliderPlugin;", "sliderDao", "Lcom/panomc/plugins/slider/db/dao/SliderDao;", "<init>", "(Lcom/panomc/plugins/slider/SliderPlugin;Lcom/panomc/plugins/slider/db/dao/SliderDao;)V", "paths", "", "Lcom/panomc/platform/model/Path;", "getPaths", "()Ljava/util/List;", "authProvider", "Lcom/panomc/platform/auth/AuthProvider;", "kotlin.jvm.PlatformType", "getAuthProvider", "()Lcom/panomc/platform/auth/AuthProvider;", "authProvider$delegate", "Lkotlin/Lazy;", "databaseManager", "Lcom/panomc/platform/db/DatabaseManager;", "getDatabaseManager", "()Lcom/panomc/platform/db/DatabaseManager;", "databaseManager$delegate", "getValidationHandler", "Lio/vertx/ext/web/validation/ValidationHandler;", "schemaRepository", "Lio/vertx/json/schema/SchemaRepository;", "handle", "Lcom/panomc/platform/model/Result;", "context", "Lio/vertx/ext/web/RoutingContext;", "(Lio/vertx/ext/web/RoutingContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getThumbnailFile", "Ljava/io/File;", "fileName", "", "Companion", "pano-plugin-slider"})
public final class PanelGetSliderImageAPI
extends PanelApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SliderPlugin plugin;
    @NotNull
    private final SliderDao sliderDao;
    @NotNull
    private final List<Path> paths;
    @NotNull
    private final Lazy authProvider$delegate;
    @NotNull
    private final Lazy databaseManager$delegate;
    private static final int CACHE_TTL_SECONDS = 604800;

    public PanelGetSliderImageAPI(@NotNull SliderPlugin plugin, @NotNull SliderDao sliderDao) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)((Object)sliderDao), (String)"sliderDao");
        this.plugin = plugin;
        this.sliderDao = sliderDao;
        this.paths = CollectionsKt.listOf((Object)new Path("/api/panel/slider/items/image/:fileName", RouteType.GET));
        this.authProvider$delegate = LazyKt.lazy(() -> PanelGetSliderImageAPI.authProvider_delegate$lambda$0(this));
        this.databaseManager$delegate = LazyKt.lazy(() -> PanelGetSliderImageAPI.databaseManager_delegate$lambda$0(this));
    }

    @NotNull
    public List<Path> getPaths() {
        return this.paths;
    }

    private final AuthProvider getAuthProvider() {
        Lazy lazy = this.authProvider$delegate;
        return (AuthProvider)lazy.getValue();
    }

    private final DatabaseManager getDatabaseManager() {
        Lazy lazy = this.databaseManager$delegate;
        return (DatabaseManager)lazy.getValue();
    }

    @NotNull
    public ValidationHandler getValidationHandler(@NotNull SchemaRepository schemaRepository) {
        Intrinsics.checkNotNullParameter((Object)schemaRepository, (String)"schemaRepository");
        ValidationHandler validationHandler = ValidationHandlerBuilder.create((SchemaRepository)schemaRepository).pathParameter(Parameters.param((String)"fileName", (StringSchemaBuilder)Schemas.stringSchema())).queryParameter(Parameters.optionalParam((String)"thumbnail", (BooleanSchemaBuilder)Schemas.booleanSchema())).build();
        Intrinsics.checkNotNullExpressionValue((Object)validationHandler, (String)"build(...)");
        return validationHandler;
    }

    @Nullable
    public Object handle(@NotNull RoutingContext context, @NotNull Continuation<? super Result> $completion) {
        File file;
        File file2;
        boolean isThumbnail;
        RequestParameters parameters = this.getParameters(context);
        String fileName = parameters.pathParameter("fileName").getString();
        Object object = parameters.queryParameter("thumbnail");
        boolean bl = object != null && (object = object.getBoolean()) != null ? (Boolean)object : (isThumbnail = false);
        if (isThumbnail) {
            Intrinsics.checkNotNull((Object)fileName);
            file2 = this.getThumbnailFile(fileName);
        } else {
            file2 = file = new File(this.plugin.getUploadsDir(), fileName);
        }
        if (!file.exists()) {
            context.response().setStatusCode(404).end();
            return null;
        }
        String etag = "\"" + fileName + "\"";
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        String mimeType = MimeTypeUtil.INSTANCE.getMimeTypeFromFileName(string);
        HttpServerResponse response = context.response();
        response.putHeader("Content-Type", mimeType);
        response.putHeader("ETag", etag);
        response.putHeader("Cache-Control", "public, max-age=604800, immutable");
        try {
            response.sendFile(file.getAbsolutePath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private final File getThumbnailFile(String fileName) {
        File thumbnailsDir = new File(this.plugin.getUploadsDir(), "thumbnails");
        File originalFile = new File(this.plugin.getUploadsDir(), fileName);
        if (!originalFile.exists()) {
            return originalFile;
        }
        ImageUtil.INSTANCE.generateThumbnail(originalFile, thumbnailsDir);
        File thumbnailFile = new File(thumbnailsDir, fileName);
        return thumbnailFile.exists() ? thumbnailFile : originalFile;
    }

    private static final AuthProvider authProvider_delegate$lambda$0(PanelGetSliderImageAPI this$0) {
        return (AuthProvider)this$0.plugin.getApplicationContext().getBean(AuthProvider.class);
    }

    private static final DatabaseManager databaseManager_delegate$lambda$0(PanelGetSliderImageAPI this$0) {
        return (DatabaseManager)this$0.plugin.getApplicationContext().getBean(DatabaseManager.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/panomc/plugins/slider/routes/panel/PanelGetSliderImageAPI$Companion;", "", "<init>", "()V", "CACHE_TTL_SECONDS", "", "pano-plugin-slider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

