/*
 * Decompiled with CFR 0.152.
 */
package com.panomc.plugins.slider.util;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/panomc/plugins/slider/util/ImageUtil;", "", "<init>", "()V", "THUMBNAIL_SIZE", "", "generateThumbnail", "", "originalFile", "Ljava/io/File;", "thumbnailsDir", "pano-plugin-slider"})
public final class ImageUtil {
    @NotNull
    public static final ImageUtil INSTANCE = new ImageUtil();
    private static final int THUMBNAIL_SIZE = 128;

    private ImageUtil() {
    }

    public final boolean generateThumbnail(@NotNull File originalFile, @NotNull File thumbnailsDir) {
        File thumbnailFile;
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)thumbnailsDir, (String)"thumbnailsDir");
        if (!originalFile.exists()) {
            return false;
        }
        if (!thumbnailsDir.exists()) {
            thumbnailsDir.mkdirs();
        }
        if ((thumbnailFile = new File(thumbnailsDir, originalFile.getName())).exists()) {
            return true;
        }
        try {
            String extension;
            BufferedImage bufferedImage = ImageIO.read(originalFile);
            if (bufferedImage == null) {
                return false;
            }
            BufferedImage originalImage = bufferedImage;
            int type = originalImage.getType() == 0 ? 2 : originalImage.getType();
            int width = originalImage.getWidth();
            int height = originalImage.getHeight();
            if (width > 128 || height > 128) {
                if (width > height) {
                    height = height * 128 / width;
                    width = 128;
                } else {
                    width = width * 128 / height;
                    height = 128;
                }
            }
            BufferedImage resizedImage = new BufferedImage(width, height, type);
            Graphics2D g = resizedImage.createGraphics();
            g.drawImage(originalImage.getScaledInstance(width, height, 4), 0, 0, null);
            g.dispose();
            String string = originalFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String[] stringArray = new String[]{"."};
            String string2 = ((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null))).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String string3 = extension = string2;
            String formatName = Intrinsics.areEqual((Object)string3, (Object)"png") ? "png" : (Intrinsics.areEqual((Object)string3, (Object)"gif") ? "gif" : "jpg");
            return ImageIO.write((RenderedImage)resizedImage, formatName, thumbnailFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

