/*
 * Decompiled with CFR 0.152.
 */
package com.panomc.plugins.slider.routes.api;

import com.panomc.platform.annotation.Endpoint;
import com.panomc.platform.model.Api;
import com.panomc.platform.model.Path;
import com.panomc.platform.model.Result;
import com.panomc.platform.model.RouteType;
import com.panomc.platform.util.MimeTypeUtil;
import com.panomc.plugins.slider.SliderPlugin;
import com.panomc.plugins.slider.util.ImageUtil;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.validation.RequestParameters;
import io.vertx.ext.web.validation.ValidationHandler;
import io.vertx.ext.web.validation.builder.Parameters;
import io.vertx.ext.web.validation.builder.ValidationHandlerBuilder;
import io.vertx.json.schema.SchemaRepository;
import io.vertx.json.schema.common.dsl.BooleanSchemaBuilder;
import io.vertx.json.schema.common.dsl.Schemas;
import io.vertx.json.schema.common.dsl.StringSchemaBuilder;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Endpoint
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/panomc/plugins/slider/routes/api/GetSliderImageAPI;", "Lcom/panomc/platform/model/Api;", "plugin", "Lcom/panomc/plugins/slider/SliderPlugin;", "<init>", "(Lcom/panomc/plugins/slider/SliderPlugin;)V", "paths", "", "Lcom/panomc/platform/model/Path;", "getPaths", "()Ljava/util/List;", "getValidationHandler", "Lio/vertx/ext/web/validation/ValidationHandler;", "schemaRepository", "Lio/vertx/json/schema/SchemaRepository;", "handle", "Lcom/panomc/platform/model/Result;", "context", "Lio/vertx/ext/web/RoutingContext;", "(Lio/vertx/ext/web/RoutingContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getThumbnailFile", "Ljava/io/File;", "fileName", "", "Companion", "pano-plugin-slider"})
public final class GetSliderImageAPI
extends Api {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SliderPlugin plugin;
    @NotNull
    private final List<Path> paths;
    private static final int CACHE_TTL_SECONDS = 604800;

    public GetSliderImageAPI(@NotNull SliderPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
        this.paths = CollectionsKt.listOf((Object)new Path("/api/slider/items/image/:fileName", RouteType.GET));
    }

    @NotNull
    public List<Path> getPaths() {
        return this.paths;
    }

    @NotNull
    public ValidationHandler getValidationHandler(@NotNull SchemaRepository schemaRepository) {
        Intrinsics.checkNotNullParameter((Object)schemaRepository, (String)"schemaRepository");
        ValidationHandler validationHandler = ValidationHandlerBuilder.create((SchemaRepository)schemaRepository).pathParameter(Parameters.param((String)"fileName", (StringSchemaBuilder)Schemas.stringSchema())).queryParameter(Parameters.optionalParam((String)"thumbnail", (BooleanSchemaBuilder)Schemas.booleanSchema())).build();
        Intrinsics.checkNotNullExpressionValue((Object)validationHandler, (String)"build(...)");
        return validationHandler;
    }

    @Nullable
    public Object handle(@NotNull RoutingContext context, @NotNull Continuation<? super Result> $completion) {
        File file;
        File file2;
        boolean isThumbnail;
        RequestParameters parameters = this.getParameters(context);
        String fileName = parameters.pathParameter("fileName").getString();
        Object object = parameters.queryParameter("thumbnail");
        boolean bl = object != null && (object = object.getBoolean()) != null ? (Boolean)object : (isThumbnail = false);
        if (isThumbnail) {
            Intrinsics.checkNotNull((Object)fileName);
            file2 = this.getThumbnailFile(fileName);
        } else {
            file2 = file = new File(this.plugin.getUploadsDir(), fileName);
        }
        if (!file.exists()) {
            context.response().setStatusCode(404).end();
            return null;
        }
        String etag = "\"" + fileName + "\"";
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        String mimeType = MimeTypeUtil.INSTANCE.getMimeTypeFromFileName(string);
        HttpServerResponse response = context.response();
        response.putHeader("Content-Type", mimeType);
        response.putHeader("ETag", etag);
        response.putHeader("Cache-Control", "public, max-age=604800, immutable");
        try {
            response.sendFile(file.getAbsolutePath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private final File getThumbnailFile(String fileName) {
        File thumbnailsDir = new File(this.plugin.getUploadsDir(), "thumbnails");
        File originalFile = new File(this.plugin.getUploadsDir(), fileName);
        if (!originalFile.exists()) {
            return originalFile;
        }
        ImageUtil.INSTANCE.generateThumbnail(originalFile, thumbnailsDir);
        File thumbnailFile = new File(thumbnailsDir, fileName);
        return thumbnailFile.exists() ? thumbnailFile : originalFile;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/panomc/plugins/slider/routes/api/GetSliderImageAPI$Companion;", "", "<init>", "()V", "CACHE_TTL_SECONDS", "", "pano-plugin-slider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

